package com.els.base.payment.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.payment.dao.BillPaymentMapper;
import com.els.base.payment.entity.BillPayment;
import com.els.base.payment.entity.BillPaymentExample;
import com.els.base.payment.service.BillPaymentService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultBillPaymentService")
public class BillPaymentServiceImpl implements BillPaymentService {
    @Resource
    protected BillPaymentMapper billPaymentMapper;

    @CacheEvict(value={"billPayment"}, allEntries=true)
    @Override
    public int insertBatch(List<BillPayment> list) {
        Assert.isNotEmpty(list,"付款明细不能为空！");
        return this.billPaymentMapper.insertBatch(list);
    }

    @CacheEvict(value={"billPayment"}, allEntries=true)
    @Override
    public void addObj(BillPayment t) {
        this.billPaymentMapper.insertSelective(t);
    }

    @CacheEvict(value={"billPayment"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.billPaymentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billPayment"}, allEntries=true)
    @Override
    public void modifyObj(BillPayment t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.billPaymentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="billPayment", keyGenerator="redisKeyGenerator")
    @Override
    public BillPayment queryObjById(String id) {
        return this.billPaymentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="billPayment", keyGenerator="redisKeyGenerator")
    @Override
    public List<BillPayment> queryAllObjByExample(BillPaymentExample example) {
        return this.billPaymentMapper.selectByExample(example);
    }

    @Cacheable(value="billPayment", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BillPayment> queryObjByPage(BillPaymentExample example) {
        PageView<BillPayment> pageView = example.getPageView();
        pageView.setQueryResult(this.billPaymentMapper.selectByExampleByPage(example));
        return pageView;
    }
}