package com.els.base.payment.vo;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * 参数
 * 会计年度
 * 凭证日期
 * 供应商
 * 分配号
 * 查询类型
 * 公司代码
 *
 * @author liuhf
 */
public class BillPaymentVo implements Serializable {

    @ApiModelProperty("查询参数类型")
    private String type;

    @ApiModelProperty("会计开始年度")
    private int startYear;

    @ApiModelProperty("会计结束年度")
    private int endYear;

    @ApiModelProperty("凭证开始日期")
    private Date paymentStartTime;

    @ApiModelProperty("凭证结束日期")
    private Date paymentEndTime;

    @ApiModelProperty("供应商SAP编码")
    private String companySapCode;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getStartYear() {
        return startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getEndYear() {
        return endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public Date getPaymentStartTime() {
        return paymentStartTime;
    }

    public void setPaymentStartTime(Date paymentStartTime) {
        this.paymentStartTime = paymentStartTime;
    }

    public Date getPaymentEndTime() {
        return paymentEndTime;
    }

    public void setPaymentEndTime(Date paymentEndTime) {
        this.paymentEndTime = paymentEndTime;
    }

    public String getCompanySapCode() {
        return companySapCode;
    }

    public void setCompanySapCode(String companySapCode) {
        this.companySapCode = companySapCode;
    }
}
