package com.els.base.rebate.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value="预制发票-折让物料汇总表")
public class BillInvoiceRebate implements Serializable {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("采购商公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购商公司SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商公司SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("采购商公司简称")
    private String purCompanyName;

    @ApiModelProperty("采购商公司全称")
    private String purCompanyFullName;

    @ApiModelProperty("供应商公司ID")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商公司全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商公司SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商公司SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("物料编码")
    private String materialNo;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("物料数量")
    private BigDecimal materialQuantity;

    @ApiModelProperty("工厂")
    private String factory;

    @ApiModelProperty("开票未税金额")
    private BigDecimal notIncludeTaxAmount;

    @ApiModelProperty("开票含税金额")
    private BigDecimal includeTaxAmount;

    @ApiModelProperty("开票税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("对账清单ID")
    private String billId;

    @ApiModelProperty("对账清单号")
    private String billNo;

    @ApiModelProperty("发票ID")
    private String billInvoiceId;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("借方/贷方标识(折让单默认为H)")
    private String dbCrInd;

    @ApiModelProperty("单位")
    private String currencyType;

    @ApiModelProperty("物料单位")
    private String materialUnit;

    @ApiModelProperty("是否是折让单(0=不是折让单，1=折让单)")
    private Integer isRebate;

    @ApiModelProperty("折让不含税金额")
    private BigDecimal rebateNotIncludeTaxAmount;

    @ApiModelProperty("折让含税金额")
    private BigDecimal rebateIncludeTaxAmount;

    @ApiModelProperty("折让税额")
    private BigDecimal rebateTaxAmount;

    @ApiModelProperty("移动类型对应的符号")
    private String billTypeSign;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getMaterialNo() {
        return materialNo;
    }

    public void setMaterialNo(String materialNo) {
        this.materialNo = materialNo == null ? null : materialNo.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public BigDecimal getMaterialQuantity() {
        return materialQuantity;
    }

    public void setMaterialQuantity(BigDecimal materialQuantity) {
        this.materialQuantity = materialQuantity;
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory == null ? null : factory.trim();
    }

    public BigDecimal getNotIncludeTaxAmount() {
        return notIncludeTaxAmount;
    }

    public void setNotIncludeTaxAmount(BigDecimal notIncludeTaxAmount) {
        this.notIncludeTaxAmount = notIncludeTaxAmount;
    }

    public BigDecimal getIncludeTaxAmount() {
        return includeTaxAmount;
    }

    public void setIncludeTaxAmount(BigDecimal includeTaxAmount) {
        this.includeTaxAmount = includeTaxAmount;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getBillId() {
        return billId;
    }

    public void setBillId(String billId) {
        this.billId = billId == null ? null : billId.trim();
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo == null ? null : billNo.trim();
    }

    public String getBillInvoiceId() {
        return billInvoiceId;
    }

    public void setBillInvoiceId(String billInvoiceId) {
        this.billInvoiceId = billInvoiceId == null ? null : billInvoiceId.trim();
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode == null ? null : taxCode.trim();
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getDbCrInd() {
        return dbCrInd;
    }

    public void setDbCrInd(String dbCrInd) {
        this.dbCrInd = dbCrInd == null ? null : dbCrInd.trim();
    }

    public String getCurrencyType() {
        return currencyType;
    }

    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType == null ? null : currencyType.trim();
    }

    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit == null ? null : materialUnit.trim();
    }

    public Integer getIsRebate() {
        return isRebate;
    }

    public void setIsRebate(Integer isRebate) {
        this.isRebate = isRebate;
    }

    public BigDecimal getRebateNotIncludeTaxAmount() {
        return rebateNotIncludeTaxAmount;
    }

    public void setRebateNotIncludeTaxAmount(BigDecimal rebateNotIncludeTaxAmount) {
        this.rebateNotIncludeTaxAmount = rebateNotIncludeTaxAmount;
    }

    public BigDecimal getRebateIncludeTaxAmount() {
        return rebateIncludeTaxAmount;
    }

    public void setRebateIncludeTaxAmount(BigDecimal rebateIncludeTaxAmount) {
        this.rebateIncludeTaxAmount = rebateIncludeTaxAmount;
    }

    public BigDecimal getRebateTaxAmount() {
        return rebateTaxAmount;
    }

    public void setRebateTaxAmount(BigDecimal rebateTaxAmount) {
        this.rebateTaxAmount = rebateTaxAmount;
    }

    public String getBillTypeSign() {
        return billTypeSign;
    }

    public void setBillTypeSign(String billTypeSign) {
        this.billTypeSign = billTypeSign == null ? null : billTypeSign.trim();
    }
}