package com.els.base.rebate.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.rebate.dao.BillInvoiceRebateMapper;
import com.els.base.rebate.entity.BillInvoiceRebate;
import com.els.base.rebate.entity.BillInvoiceRebateExample;
import com.els.base.rebate.service.BillInvoiceRebateService;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultBillInvoiceRebateService")
public class BillInvoiceRebateServiceImpl implements BillInvoiceRebateService {
    @Resource
    protected BillInvoiceRebateMapper billInvoiceRebateMapper;

    @CacheEvict(value={"billInvoiceRebate"}, allEntries=true)
    @Transactional
    @Override
    public void deleteInvoiceRebate(BillInvoice billInvoice) {

        Assert.isNotNull(billInvoice,"发票信息不能为空！");
        Assert.isNotBlank(billInvoice.getId(),"发票ID信息不能为空！");
        Assert.isNotBlank(billInvoice.getBillId(),"对账清单ID不能为空！");

        BillInvoiceRebateExample billInvoiceRebateExample =new BillInvoiceRebateExample();
        billInvoiceRebateExample.createCriteria()
                .andBillIdEqualTo(billInvoice.getBillId())
                .andBillInvoiceIdEqualTo((billInvoice.getId()));

        List<BillInvoiceRebate> billInvoiceRebates = this.billInvoiceRebateMapper.selectByExample(billInvoiceRebateExample);
        if(CollectionUtils.isEmpty(billInvoiceRebates)){
            for (BillInvoiceRebate billInvoiceRebate : billInvoiceRebates) {
                this.billInvoiceRebateMapper.deleteByPrimaryKey(billInvoiceRebate.getId());
            }
        }
    }

    @CacheEvict(value={"billInvoiceRebate"}, allEntries=true)
    @Override
    public void addObj(BillInvoiceRebate t) {
        this.billInvoiceRebateMapper.insertSelective(t);
    }

    @CacheEvict(value={"billInvoiceRebate"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.billInvoiceRebateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billInvoiceRebate"}, allEntries=true)
    @Override
    public void modifyObj(BillInvoiceRebate t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.billInvoiceRebateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="billInvoiceRebate", keyGenerator="redisKeyGenerator")
    @Override
    public BillInvoiceRebate queryObjById(String id) {
        return this.billInvoiceRebateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="billInvoiceRebate", keyGenerator="redisKeyGenerator")
    @Override
    public List<BillInvoiceRebate> queryAllObjByExample(BillInvoiceRebateExample example) {
        return this.billInvoiceRebateMapper.selectByExample(example);
    }

    @Cacheable(value="billInvoiceRebate", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BillInvoiceRebate> queryObjByPage(BillInvoiceRebateExample example) {
        PageView<BillInvoiceRebate> pageView = example.getPageView();
        pageView.setQueryResult(this.billInvoiceRebateMapper.selectByExampleByPage(example));
        return pageView;
    }
}