package com.els.base.voucher.command;

import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.entity.BillVoucherExample;

import java.util.List;

/**
 *
 * 删除未对账的可开票数据
 * @author liuhf
 *
 */
public class DeleteCommand extends AbstractBillCommand<String> {

    private List<String> ids;

	public DeleteCommand() {
	}

	public DeleteCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
    	this.billInvorker = billInvorker;

    	this.validData(ids);

    	this.handle(ids);
    	
        return null;
    }

	/**
	 * 删除数据
	 */
	private void handle(List<String> ids) {
		BillVoucherExample example = new BillVoucherExample();
		example.createCriteria().andIdIn(ids);
		int i = this.billInvorker.getBillVoucherService().countByExample(example);
		if(i>0){
			this.billInvorker.getBillVoucherService().deleteByExample(example);
		}
	}

	/**
	 * 校验数据是否可以删除
	 */
	private void validData(List<String> ids) {
		Assert.isNotEmpty(this.ids,"凭证ID不能为空！");
		BillVoucherExample example = new BillVoucherExample();
		example.createCriteria()
				.andIdIn(ids)
				.andBillFlagEqualTo(Constant.YES_INT);
		int count=this.billInvorker.getBillVoucherService().countByExample(example);
		if(count>0){
			throw  new CommonException("所选的可开票凭证中存在已对账凭证，不能删除，请检查！");
		}
	}

}
