package com.els.base.voucher.command;

import com.els.base.bill.command.CreateBillFilterCommand;
import com.els.base.bill.command.PostTimeFilterCommand;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.AbstractResultVO;
import com.els.base.utils.SpringContextHolder;
import com.els.base.voucher.service.BillVoucherImportFromSapService;
import com.els.base.voucher.vo.ImportVoucherVo;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Calendar;
import java.util.Date;

/**
 * 同步入退库凭证
 * @author liuhf
 */
public class SapImportCommand extends AbstractBillCommand<AbstractResultVO> {

    Logger logger =LoggerFactory.getLogger(this.getClass());

    private  ImportVoucherVo importVoucherVo;

    public SapImportCommand(ImportVoucherVo importVoucherVo){
        this.importVoucherVo=importVoucherVo;
    }

    @Override
    public AbstractResultVO execute(BillInvorker billInvorker) {
        this.billInvorker =billInvorker;

        String supCompanySapCode = importVoucherVo.getSupCompanySapCode();
        Date startTime = importVoucherVo.getStartTime();
        Date endTime = importVoucherVo.getEndTime();

        Assert.isNotBlank(supCompanySapCode, "供应商SAP编码不能为空！");
        Assert.isNotNull(startTime, "凭证开始时间不能为空！");
        Assert.isNotNull(endTime, "凭证结束时间不能为空！");

        logger.info("供应商SAP编码:{}",supCompanySapCode);
        logger.info("凭证开始时间:{}",startTime);
        logger.info("凭证结束时间:{}",endTime);

        //验证供应商是否在开票日期
        CreateBillFilterCommand cmd = new CreateBillFilterCommand(supCompanySapCode);
        this.billInvorker.invoke(cmd);

        //验证这些凭证是否在开票日期
        PostTimeFilterCommand cmd2 = new PostTimeFilterCommand(supCompanySapCode,startTime,endTime);
        this.billInvorker.invoke(cmd2);

        //发起sap请求
        Date startTime1 = DateUtils.truncate(startTime, Calendar.DATE);
        Date endTime1 = DateUtils.truncate(endTime, Calendar.DATE);
        String startTimeStr = DateFormatUtils.format(startTime1, "yyyy-MM-dd");
        String endTimeStr = DateFormatUtils.format(endTime1, "yyyy-MM-dd");
        //开始时间需要小于结束时间
        if (startTime1.getTime() > endTime1.getTime()) {
            throw new CommonException("凭证开始时间不能大于凭证结束时间！");
        }
        AbstractResultVO abstractResultVO = SpringContextHolder.getOneBean(BillVoucherImportFromSapService.class).importByVoucherDate(supCompanySapCode, startTimeStr, endTimeStr);
        return abstractResultVO;
    }
}
