package com.els.base.voucher.command;

import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;

import java.io.IOException;
import java.util.List;

/**
 * 供应方导出可开票凭证
 * @author liuhf
 */
public class SupExportExcelCommand extends AbstractBillCommand<FileData> {

    private QueryParamWapper wapper;

    public SupExportExcelCommand() {
    }

    public SupExportExcelCommand(QueryParamWapper wapper) {
        this.wapper = wapper;
    }

    @Override
    public FileData execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        BillVoucherExample example = new BillVoucherExample();
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT)
                .andSupCompanyIdEqualTo(this.getSupCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List<BillVoucher> billVoucherList = this.billInvorker.getBillVoucherService().queryAllObjByExample(example);
        FileData fileData = new FileData();
        try {
            fileData = ExportExcelUtil.getBillVoucherFileData(billVoucherList);
        } catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("导出异常！");
        }
        return fileData;
    }
}
