package com.els.base.voucher.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.BillInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.voucher.command.DeleteCommand;
import com.els.base.voucher.command.PurExportExcelCommand;
import com.els.base.voucher.command.SapImportCommand;
import com.els.base.voucher.command.SupExportExcelCommand;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherImportFromSapService;
import com.els.base.voucher.service.BillVoucherService;
import com.els.base.voucher.utils.BillVoucherEnum;
import com.els.base.voucher.utils.ForBillIntegerConverter;
import com.els.base.voucher.vo.BillVoucherVo;
import com.els.base.voucher.vo.ImportVoucherVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.*;
import java.util.stream.Collectors;

@Api(value = "采购结算管理-开票清单入退库凭证,折让单")
@Controller
@RequestMapping("billVoucher")
public class BillVoucherController {

    Logger logger = LoggerFactory.getLogger(BillVoucher.class);
    @Resource
    private BillVoucherService billVoucherService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(value = "供应商导出入退库凭证数据", httpMethod = "POST")
    @RequestMapping(value = "service/sup/exportBillVoucher")
    @ResponseBody
    public ResponseResult<FileData> exportBillVoucherForSup(
            @RequestBody(required = false) QueryParamWapper wapper) throws IOException {
        SupExportExcelCommand cmd = new SupExportExcelCommand(wapper);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        FileData fileData=this.invoker.invoke(cmd);
        return ResponseResult.success(fileData);
    }


    @ApiOperation(value = "采购商导出入退库以及折让单数据", httpMethod = "POST")
    @RequestMapping(value = "service/pur/exportBillVoucher")
    @ResponseBody
    public ResponseResult<FileData> exportBillVoucherForPur(
            @RequestBody(required = false) QueryParamWapper wapper) throws IOException {

        PurExportExcelCommand cmd = new PurExportExcelCommand(wapper);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        FileData fileData=this.invoker.invoke(cmd);
        return ResponseResult.success(fileData);
    }



    @ApiOperation(httpMethod = "GET", value = "采购方和供应方从sap同步可开票清单数据到srm")
    @RequestMapping("service/importVoucherFromSap")
    @ResponseBody
    public ResponseResult<String> importVoucherFromSap(
            @RequestParam(required = true) String supCompanySapCode,
            @RequestParam(required = true) Date startTime,
            @RequestParam(required = true) Date endTime) {
        ImportVoucherVo importVoucherVo =new ImportVoucherVo();
        importVoucherVo.setSupCompanySapCode(supCompanySapCode);
        importVoucherVo.setStartTime(startTime);
        importVoucherVo.setEndTime(endTime);
        SapImportCommand cmd =new SapImportCommand(importVoucherVo);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购方和供应方从sap同步可开票清单数据到srm")
    @RequestMapping("service/importVoucherFromSap2")
    @ResponseBody
    public ResponseResult<String> importVoucherFromSap(@RequestBody(required = true) ImportVoucherVo importVoucherVo) {
        SapImportCommand cmd =new SapImportCommand(importVoucherVo);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "删除可开票清单")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<String> ids) {
        DeleteCommand cmd =new DeleteCommand(ids);
        invoker.invoke(cmd);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "供应商方--分页查询可开票清单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BillVoucher", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/sup/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findByPageForSup(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {

        //查询条件
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView(new PageView<BillVoucher>(pageNo, pageSize));

        //添加默认排序：按照创建时间倒序排
        example.setOrderByClause("CREATE_TIME DESC");

        //采购商
        Company company = CompanyUtils.currentCompany();
        BillVoucherExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andIsEnableEqualTo(Constant.YES_INT)
                .andSupCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView<BillVoucher> pageData = this.billVoucherService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "采购方--分页查询可开票清单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BillVoucher", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/pur/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findByPageForPur(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {

        //查询条件
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView(new PageView<BillVoucher>(pageNo, pageSize));

        //添加默认排序：按照创建时间倒序排
        example.setOrderByClause("CREATE_TIME DESC");

        //采购商
        Company company = CompanyUtils.currentCompany();
        BillVoucherExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andIsEnableEqualTo(Constant.YES_INT)
                .andPurCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView<BillVoucher> pageData = this.billVoucherService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "1、新增开票时候,根据供应商sap编码和凭证开始和结束时间拉取未对账的sap对账明细数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BillVoucher", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/voucher/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {

        //查询条件
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView(new PageView<BillVoucher>(pageNo, pageSize));

        //添加默认排序：按照创建时间倒序排
        example.setOrderByClause("CREATE_TIME DESC");

        BillVoucherExample.Criteria criteria = example.createCriteria();

        //未对账，可用，时间段，如果需要查询折让，那么只需要传折让标识符即可
        criteria.andIsEnableEqualTo(Constant.YES_INT)
                .andBillFlagEqualTo(Constant.NO_INT)
                .andBillTypeIsNotNull();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView<BillVoucher> pageData = this.billVoucherService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "1.1、新增开票时候,根据供应商sap编码和凭证开始和结束时间拉取未对账的折让数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BillVoucher", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/rebate/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findRebateByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {

        //查询条件
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView(new PageView<BillVoucher>(pageNo, pageSize));

        //添加默认排序：按照创建时间倒序排
        example.setOrderByClause("CREATE_TIME DESC");

        BillVoucherExample.Criteria criteria = example.createCriteria();

        //未对账，可用，时间段，如果需要查询折让，那么只需要传折让标识符即可
        criteria.andIsEnableEqualTo(Constant.YES_INT)
                .andBillFlagEqualTo(Constant.NO_INT)
                .andBillTypeIsNotNull().andIsRebateEqualTo(Constant.YES_INT);

        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView<BillVoucher> pageData = this.billVoucherService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "2、新增开票清单，取消sap入退库明细的时候，返回没取消sap入退库明细对应的折让明细")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postingStartTime", required = false),
            @ApiImplicitParam(name = "postingEndTime", required = false),
            @ApiImplicitParam(name = "supCompanySapCode", required = false, paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
    })
    @RequestMapping("service/rebate/reverse/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findReverseRebateByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required = true) Date postingStartTime,
            @RequestParam(required = true) Date postingEndTime,
            @RequestParam(required = true) String supCompanySapCode,
            @RequestBody(required = false) List<BillVoucher> billVoucherList) {

        logger.info("供应商SAP编码:{}",supCompanySapCode);
        logger.info("入退库凭证开始时间:{}",postingStartTime);
        logger.info("入退库凭证结束时间:{}",postingEndTime);

        //格式化为不要时分秒
        Date postingStartTime2 = DateUtils.truncate(postingStartTime, Calendar.DATE);
        Date postingEndTime2 = DateUtils.truncate(postingEndTime, Calendar.DATE);

        //如果选中有入退库，那么
        if (CollectionUtils.isNotEmpty(billVoucherList)) {

            List<String> ids = billVoucherList.stream().map(BillVoucher::getId).collect(Collectors.toList());

            BillVoucherExample example = new BillVoucherExample();
            example.setPageView(new PageView<BillVoucher>(pageNo, pageSize));

            //添加默认排序：按照创建时间倒序排
            example.setOrderByClause("CREATE_TIME DESC");

            BillVoucherExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT)
                    .andBillFlagEqualTo(Constant.NO_INT)
                    .andSupCompanySapCodeEqualTo(supCompanySapCode)
                    .andPostingTimeBetween(postingStartTime2, postingEndTime2)
                    .andBillTypeIsNotNull()
                    .andIsRebateEqualTo(Constant.YES_INT)
                    .andIdNotIn(ids);

            PageView<BillVoucher> pageData = this.billVoucherService.queryObjByPage(example);
            return ResponseResult.success(pageData);

            //如果没有选中入退库，那么查询该供应商全部未对账折让数据
        } else {
            //查询条件
            BillVoucherExample example = new BillVoucherExample();
            example.setPageView(new PageView<BillVoucher>(pageNo, pageSize));

            //添加默认排序：按照创建时间倒序排
            example.setOrderByClause("CREATE_TIME DESC");

            BillVoucherExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT)
                    .andBillFlagEqualTo(Constant.NO_INT)
                    .andSupCompanySapCodeEqualTo(supCompanySapCode)
                    .andPostingTimeBetween(postingStartTime2, postingEndTime2)
                    .andBillTypeIsNotNull()
                    .andIsRebateEqualTo(Constant.YES_INT);
            PageView<BillVoucher> pageData = this.billVoucherService.queryObjByPage(example);
            return ResponseResult.success(pageData);
        }
    }


    @ApiOperation(httpMethod = "POST", value = "3、新增开票清单，选中sap入退库明细的时候，查看相应的折让明细")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postingStartTime", required = false),
            @ApiImplicitParam(name = "postingEndTime", required = false),
            @ApiImplicitParam(name = "supCompanySapCode", required = false, paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
    })
    @RequestMapping("service/rebate/positive/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findPositiveRebateByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required = true) Date postingStartTime,
            @RequestParam(required = true) Date postingEndTime,
            @RequestParam(required = true) String supCompanySapCode,
            @RequestBody(required = false) List<BillVoucher> billVoucherList) {

        Assert.isNotBlank(supCompanySapCode, "供应商编码不能为空！");
        Assert.isNotNull(postingStartTime, "过账开始日期不能为空！");
        Assert.isNotNull(postingEndTime, "过账结束日期不能为空！");
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank(billVoucher.getId(), "凭证ID不能为空！");
        }

        logger.info("供应商SAP编码:{}", supCompanySapCode);
        logger.info("入退库凭证开始时间:{}", postingStartTime);
        logger.info("入退库凭证结束时间:{}", postingEndTime);

        //格式化为不要时分秒
        Date postingStartTime2 = DateUtils.truncate(postingStartTime, Calendar.DATE);
        Date postingEndTime2 = DateUtils.truncate(postingEndTime, Calendar.DATE);

        if (CollectionUtils.isNotEmpty(billVoucherList)) {
            List<String> ids = billVoucherList.stream().map(BillVoucher::getId).collect(Collectors.toList());
            //查询条件
            BillVoucherExample example = new BillVoucherExample();
            example.setPageView(new PageView<BillVoucher>(pageNo, pageSize));

            //添加默认排序：按照创建时间倒序排
            example.setOrderByClause("CREATE_TIME DESC");

            BillVoucherExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT)
                    .andBillFlagEqualTo(Constant.NO_INT)
                    .andSupCompanySapCodeEqualTo(supCompanySapCode)
                    .andPostingTimeBetween(postingStartTime2, postingEndTime2)
                    .andBillTypeIsNotNull()
                    .andIsRebateEqualTo(Constant.YES_INT)
                    .andIdIn(ids);
            PageView<BillVoucher> pageData = this.billVoucherService.queryObjByPage(example);
            return ResponseResult.success(pageData);
        } else {
            PageView<BillVoucher> pageData =new PageView<>();
            pageData.setQueryResult(new ArrayList<BillVoucher>());
            return ResponseResult.success(pageData);
        }
    }

    @ApiOperation(httpMethod = "GET", value = "新建开票清单，导出未对账明细")
    @RequestMapping("service/exportSapBillDetail")
    @ResponseBody
    public ModelAndView exportSapBillDetail(
            @RequestParam(required = true) String supCompanySapCode,
            @RequestParam(required = true) Date startTime,
            @RequestParam(required = true) Date endTime, HttpServletResponse response) throws Exception {

        //1、校验数据
        Assert.isNotBlank(supCompanySapCode,"供应商的SAP编码不能为空！");
        Assert.isNotNull(startTime,"凭证开始日期不能为空！");
        Assert.isNotNull(endTime,"凭证结束日期不能为空！");

        //2、查询需要导出的数据
        BillVoucherExample example = new BillVoucherExample();
        BillVoucherExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andIsEnableEqualTo(Constant.YES_INT)
                .andBillFlagEqualTo(Constant.NO_INT)
                .andSupCompanySapCodeEqualTo(supCompanySapCode)
                .andPostingTimeBetween(startTime,endTime);
        List<BillVoucher> billVouchers = this.billVoucherService.queryAllObjByExample(example);

        List<TitleAndModelKey> titleAndModelKeys = createExportExcelHeader();
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode("SAP对账明细.xls", "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        OutputStream outputStream = response.getOutputStream();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, billVouchers, "SAP对账明细", null, 0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return null;
    }

    private List<TitleAndModelKey> createExportExcelHeader() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商简称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商公司SAP编码", "supCompanySapCode"));

        //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单号", "deliveryOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单号", "purchaseOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单行项", "purchaseOrderItemNo"));

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("过账日期", "postingTime"));

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料凭证号", "materialVoucherNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料凭证行号", "materialVoucherItemNo"));

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料单位", "materialUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料数量", "materialQuantity"));

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("最新采购信息记录价格", "latestPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单价", "orderPrice"));

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("币种", "currencyType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("税码", "taxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("税率", "taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目类别", "projectTypes"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("移动类型", "billType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("移动类型符号", "billTypeSign"));

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单金额", "orderAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开票未税金额", "notIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开票税额", "taxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开票含税金额", "includeTaxAmount"));

        ForBillIntegerConverter isRebateConverter = new ForBillIntegerConverter();
        TitleAndModelKey isRebate = ExcelUtils.createTitleAndModelKey("是否折让", "isRebate");
        isRebate.setToStrConverter(isRebateConverter);
        titleAndModelKeys.add(isRebate);

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("折让不含税金额", "rebateNotIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("折让含税金额", "rebateIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("折让税额", "rebateTaxAmount"));

        // 是否对账-转换器
       /* ForBillIntegerConverter integerConverter = new ForBillIntegerConverter();
        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("是否对账", "billFlag");
        titleAndModelKey.setToStrConverter(integerConverter);
        titleAndModelKeys.add(titleAndModelKey);*/

        return titleAndModelKeys;
    }

}