package com.els.base.voucher.excel;

import com.els.base.voucher.vo.BillVoucherVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.afterturn.easypoi.handler.impl.ExcelDataHandlerDefaultImpl;

/**
 *  handler是用来处理一些特殊事情的。
 *  比如导入的数据某些信息不能与现有数据库中的数据冲突，那么必然会查询数据库。
 *  这样的处理是上面hibernate验证框架也无法轻易实现的。
 */
public class BillVoucherExcelHandler extends ExcelDataHandlerDefaultImpl<BillVoucherVo> {

    private static final Logger log = LoggerFactory.getLogger(BillVoucherExcelHandler.class);

    @Override
    public Object importHandler(BillVoucherVo obj, String name, Object value) {
        log.info(name + ":" + value);
        return super.importHandler(obj, name, value);
    }

}