package com.els.base.voucher.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.voucher.dao.BillVoucherMapper;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service("defaultBillVoucherService")
public class BillVoucherServiceImpl implements BillVoucherService {
    @Resource
    protected BillVoucherMapper billVoucherMapper;

    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Override
    public void switchBillVoucherFlag(List<BillVoucher> billVoucherList, Integer billFlag) {
        Assert.isNotEmpty(billVoucherList,"凭证信息不能为空！");
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank(billVoucher.getId(),"凭证ID不能为空！");
        }
        List<String> ids = billVoucherList.stream().map(BillVoucher::getId).collect(Collectors.toList());
        this.switchBillVoucherFlagById(ids,billFlag);
    }

    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Override
    public void switchBillVoucherFlagById(List<String> ids, Integer billFlag) {
        Assert.isNotEmpty(ids,"凭证信息不能为空！");
        Assert.isNotNull(billFlag);
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andIdIn(ids);
        BillVoucher billVoucher = new BillVoucher();
        billVoucher.setBillFlag(billFlag);
        int i = this.billVoucherMapper.countByExample(billVoucherExample);
        if(i>0){
            this.billVoucherMapper.updateByExampleSelective(billVoucher, billVoucherExample);
        }
    }

    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Override
    public void addAll(List<BillVoucher> list) {
        Assert.isNotEmpty(list,"保存列表不能为空！");
        for (BillVoucher billVoucher : list) {
            billVoucher.setId(UUIDGenerator.generateUUID());
        }
        List<List<BillVoucher>> group = Lists.partition(list, 10);
        for (List<BillVoucher> billVouchers : group) {
            this.billVoucherMapper.insertBatch(billVouchers);
        }
    }

    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Override
    public void deleteByExample(BillVoucherExample example) {
        Assert.isNotEmpty(example.getOredCriteria(),"不能进行全表删除，请检查！");
        this.billVoucherMapper.deleteByExample(example);
    }

    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Override
    public int insertBatch(List<BillVoucher> list) {
        Assert.isNotEmpty(list,"对账凭证不能为空！");
        return this.billVoucherMapper.insertBatch(list);
    }

    @Cacheable(value="billVoucher", keyGenerator="redisKeyGenerator")
    @Transactional
    @Override
    public int countByExample(BillVoucherExample example) {
        return this.billVoucherMapper.countByExample(example);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Transactional
    @Override
    public int updateByExampleSelective(BillVoucher record, BillVoucherExample example) {
        return billVoucherMapper.updateByExampleSelective(record,example);
    }
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Override
    public void addObj(BillVoucher t) {
        this.billVoucherMapper.insertSelective(t);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.billVoucherMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Override
    public void modifyObj(BillVoucher t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.billVoucherMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="billVoucher", keyGenerator="redisKeyGenerator")
    @Override
    public BillVoucher queryObjById(String id) {
        return this.billVoucherMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="billVoucher", keyGenerator="redisKeyGenerator")
    @Override
    public List<BillVoucher> queryAllObjByExample(BillVoucherExample example) {
        return this.billVoucherMapper.selectByExample(example);
    }

    @Cacheable(value="billVoucher", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BillVoucher> queryObjByPage(BillVoucherExample example) {
        PageView<BillVoucher> pageView = example.getPageView();
        pageView.setQueryResult(this.billVoucherMapper.selectByExampleByPage(example));
        return pageView;
    }
}