package com.els.base.voucher.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 导出凭证
 *
 * @author liuhf
 */
@Data
public class BillVoucherVo implements Serializable {

    @Excel(width = 30, name = "采购商公司全称")
    private String purCompanyFullName;

    @Excel(width = 30, name = "供应商公司全称")
    private String supCompanyFullName;

    @NotBlank(message = "供应商公司SAP编码不能为空")
    @Excel(width = 20, name = "供应商公司SAP编码")
    private String supCompanySapCode;

    @Excel(width = 20, name = "采购单号")
    private String purchaseOrderNo;

    @Excel(width = 20, name = "采购单行号")
    private String purchaseOrderItemNo;

    @Excel(width = 20, name = "物料编码")
    private String materialNo;

    @Excel(width = 30, name = "物料描述")
    private String materialDesc;

    @Excel(width = 20, name = "物料数量")
    private BigDecimal materialQuantity;

    @NotBlank(message = "物料凭证号不能为空")
    @Excel(width = 20, name = "物料凭证号")
    private String materialVoucherNo;

    @NotBlank(message = "物料凭证行号不能为空")
    @Excel(width = 20, name = "物料凭证行号")
    private String materialVoucherItemNo;

    @Excel(width = 20, name = "过账时间", format = "yyyy-MM-dd",importFormat = "yyyy-MM-dd")
    private Date postingTime;

    @Excel(width = 20, name = "货币类型")
    private String currencyType;

    @Excel(width = 20, name = "移动类型")
    private String billType;

    @Excel(width = 20, name = "移动类型符号")
    private String billTypeSign;

    @Excel(width = 20, name = "是否对账", replace = {"已对账_1", "未对账_0"})
    private Integer billFlag;

    @Excel(width = 20, name = "工厂")
    private String factory;

    @Excel(width = 20, name = "项目类别")
    private String projectTypes;

    @Excel(width = 20, name = "税码")
    private String taxCode;

    @Excel(width = 20, name = "税率")
    private BigDecimal taxRate;

    @Excel(width = 20, name = "最新采购信息记录价格")
    private BigDecimal latestPrice;

    @Excel(width = 20, name = "单价")
    private BigDecimal orderPrice;

    @Excel(width = 20, name = "开票未税金额")
    private BigDecimal notIncludeTaxAmount;

    @Excel(width = 20, name = "开票含税金额")
    private BigDecimal includeTaxAmount;

    @Excel(width = 20, name = "开票税额")
    private BigDecimal taxAmount;

    @Excel(width = 20, name = "是否折让", replace = {"是_1", "否_0"})
    private Integer isRebate;

    @Excel(width = 20, name = "折让不含税金额")
    private BigDecimal rebateNotIncludeTaxAmount;

    @Excel(width = 20, name = "折让含税金额")
    private BigDecimal rebateIncludeTaxAmount;

    @Excel(width = 20, name = "折让税额")
    private BigDecimal rebateTaxAmount;

    @Excel(width = 20, name = "订单总金额")
    private BigDecimal orderAmount;

    @Excel(width = 20, name = "物料单位")
    private String materialUnit;

    private static final long serialVersionUID = 1L;
}