/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.service.impl.BillServiceImpl;
import com.els.base.bill.utils.ApproveStatusEnum;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproveCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Bill> billList;

    public ApproveCommand() {
    }

    public ApproveCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validate(this.billList);
        this.processor(this.billList);
        this.sendMessage(this.billList);
        return null;
    }

    private void sendMessage(List<Bill> billList) {
        this.logger.info("\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        billList = this.getBillInvorker().getBillService().queryAllObjByExample((IExample)billExample);
        for (Bill bill : billList) {
            HashMap<String, String> msg = new HashMap<String, String>();
            msg.put("billNo", bill.getBillNo());
            List userIdList = this.getBillInvorker().getCompanyUserRefService().queryUserOfCompany(bill.getSupCompanyId());
            if (!CollectionUtils.isNotEmpty((Collection)userIdList) || !StringUtils.isNotBlank((String)((String)userIdList.get(0)))) continue;
            Message message = Message.init(msg).setCompanyCode(bill.getPurCompanySrmCode()).setSenderId(this.getPurUser().getId()).setBusinessTypeCode("BILL_PUR_APPROVE").addReceiverId((String)userIdList.get(0)).setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
            this.logger.info("\u53d1\u9001\u5185\u5bb9\uff0c" + message);
        }
        this.logger.info("\u7ed3\u675f\u53d1\u9001\u6d88\u606f");
    }

    private void processor(List<Bill> billList) {
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        List bills = this.billInvorker.getBillService().queryAllObjByExample((IExample)billExample);
        Assert.isNotEmpty((Collection)bills, (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u64cd\u4f5c\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        for (Bill bill : bills) {
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"t345", (String)bill.getBillNo(), (String)bill.getId(), (String)("checkedBillPur?id=" + bill.getId()));
            vo.setListenerClass(BillServiceImpl.class);
            ProcessInstance startProcess = this.billInvorker.getWorkFlowService().startProcess(vo);
            if (startProcess == null) continue;
            Bill payBill = new Bill();
            payBill.setId(bill.getId());
            payBill.setApproveStatus(ApproveStatusEnum.BEING_AUDITED.getCode());
            payBill.setApproveTime(new Date());
            payBill.setApproveNo("t345");
            payBill.setApproveResult(bill.getBillNo());
            this.billInvorker.getBillService().modifyObj(payBill);
        }
    }

    private void validate(List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList<String> ids = new ArrayList<String>();
        for (Bill bill : billList) {
            Assert.isNotNull((Object)bill.getId(), (String)"\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            ids.add(bill.getId());
        }
        BillExample purConfirmBillStatusExample = new BillExample();
        purConfirmBillStatusExample.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT).andPurConfirmBillStatusEqualTo(Constant.NO_INT);
        int count = this.billInvorker.getBillService().countByExample(purConfirmBillStatusExample);
        if (count > 0) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8fd8\u6ca1\u6709\u786e\u8ba4\u53d1\u7968\u4fe1\u606f\u5462\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        BillExample supConfirmBillStatusExample = new BillExample();
        supConfirmBillStatusExample.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT).andSupConfirmBillStatusEqualTo(Constant.NO_INT);
        int count2 = this.billInvorker.getBillService().countByExample(supConfirmBillStatusExample);
        if (count2 > 0) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u8fd8\u672a\u56de\u7b7e\u6e05\u5355\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

