/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.utils.BillUtil;
import com.els.base.bill.utils.CalculateBillUtil;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CreateCommand
extends AbstractBillCommand<Bill> {
    private Bill bill;

    public CreateCommand() {
    }

    public CreateCommand(Bill bill) {
        this.bill = bill;
    }

    @Override
    public Bill execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.billInvorker.getBillService().prepareFilter(this.bill);
        this.billInvorker.getBillService().createBillFilter(this.bill);
        String nextCode = this.billInvorker.getGenerateCodeService().getNextCode("BILL_NO");
        this.bill.setBillNo(nextCode);
        this.init(this.bill);
        this.billInvorker.getBillService().addObj(this.bill);
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andBillTypeIsNotNull().andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andSupCompanySapCodeEqualTo(this.bill.getSupCompanySapCode()).andPostingTimeBetween(this.bill.getPostingStartTime(), this.bill.getPostingEndTime());
        List myList = this.billInvorker.getBillVoucherService().queryAllObjByExample((IExample)billVoucherExample);
        Assert.isNotEmpty((Collection)myList, (String)"\u672a\u5b58\u5728\u9700\u8981\u5bf9\u8d26\u7684\u5f00\u7968\u51ed\u8bc1\uff01");
        List<BillVoucher> otherList = this.bill.getBillVoucherList();
        if (CollectionUtils.isNotEmpty(otherList)) {
            myList.removeAll(otherList);
        }
        Assert.isNotEmpty((Collection)myList, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u4ee5\u4e0a\u7684\u5165\u9000\u5e93\u51ed\u8bc1\u5355\u636e\uff0c\u8c22\u8c22\uff01");
        this.insertBillItem(myList);
        CalculateBillUtil.calculateAmount(this.bill, myList);
        this.billInvorker.getBillService().modifyObj(this.bill);
        this.billInvorker.getBillVoucherService().switchBillVoucherFlag(myList, Constant.YES_INT);
        return null;
    }

    private void init(Bill bill) {
        bill = BillUtil.setPurCompanyInfo(this.getProject(), bill, this.billInvorker.getCompanyService());
        bill = BillUtil.setSupCompanyInfo(bill.getSupCompanySapCode(), bill, this.billInvorker.getCompanyService());
        bill.setCreateTime(new Date());
        bill.setInvoiceSignFlag(Constant.NO_INT);
    }

    private void insertBillItem(List<BillVoucher> myList) {
        List<List<BillItem>> group = BillUtil.setBillItems(this.bill, myList);
        for (List<BillItem> list : group) {
            this.billInvorker.getBillItemService().insertBatch(list);
        }
    }
}

