/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.List;
import java.util.stream.Collectors;

public class DeleteCommand
extends AbstractBillCommand<String> {
    private List<Bill> billList;

    public DeleteCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validData(this.billList);
        this.processor(this.billList);
        return null;
    }

    private void processor(List<Bill> billList) {
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids);
        Bill bill = new Bill();
        bill.setIsEnable(Constant.NO_INT);
        this.billInvorker.getBillService().updateByExampleSelective(bill, billExample);
        this.billInvorker.getBillService().updateVoucherByBillIds(ids, Constant.NO_INT);
    }

    private void validData(List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u64cd\u4f5c\u5931\u8d25,ids\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        for (Bill bill : billList) {
            Assert.isNotBlank((String)bill.getId(), (String)"\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.or().andIdIn(ids).andPurSendStatusEqualTo(Constant.YES_INT);
        billExample.or().andIdIn(ids).andSupSendStatusEqualTo(Constant.YES_INT);
        int i = this.billInvorker.getBillService().countByExample(billExample);
        if (i > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u542b\u6709\u5df2\u53d1\u9001\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
    }
}

