/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class PreviewCommand
extends AbstractBillCommand<Bill> {
    List<BillVoucher> billVoucherList;

    public List<BillVoucher> getBillVoucherList() {
        return this.billVoucherList;
    }

    public void setBillVoucherList(List<BillVoucher> billVoucherList) {
        this.billVoucherList = billVoucherList;
    }

    @Override
    public Bill execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.billVoucherList = this.validData(this.billVoucherList);
        return this.processor(this.billVoucherList);
    }

    private Bill processor(List<BillVoucher> billVoucherList) {
        Bill bill = new Bill();
        return bill;
    }

    private List<BillVoucher> validData(List<BillVoucher> billVoucherList) {
        Assert.isNotEmpty(billVoucherList, (String)"\u53ef\u5f00\u7968\u6e05\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank((String)billVoucher.getId(), (String)"\u53ef\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        List ids = billVoucherList.stream().map(BillVoucher::getId).collect(Collectors.toList());
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT);
        billVoucherList = this.billInvorker.getBillVoucherService().queryAllObjByExample((IExample)billVoucherExample);
        Assert.isNotEmpty((Collection)billVoucherList, (String)"\u5f00\u7968\u6e05\u5355\u884c\u51ed\u8bc1\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank((String)billVoucher.getId(), (String)"\u53ef\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            Assert.isNotBlank((String)billVoucher.getBillType(), (String)"\u53ef\u5f00\u7968\u51ed\u8bc1\u884c\u7684\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            if (!Constant.YES_INT.equals(billVoucher.getBillFlag())) continue;
            throw new CommonException("\u6240\u9009\u7684\u5355\u636e\u4e2d\u5b58\u5728\u5df2\u7ecf\u5f00\u8fc7\u5f00\u7968\u6e05\u5355\u7684\u884c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
        return billVoucherList;
    }
}

