/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.utils.ApproveStatusEnum;
import com.els.base.bill.utils.BillSendStatus;
import com.els.base.bill.utils.BillStatusConfirmEnum;
import com.els.base.bill.utils.BillUtil;
import com.els.base.bill.utils.CalculateBillUtil;
import com.els.base.bill.utils.CreateBillType;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.command.SapImportCommand;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.vo.ImportVoucherVo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurPrepareCommand
extends AbstractBillCommand<Bill> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private Bill bill;

    public PurPrepareCommand() {
    }

    public PurPrepareCommand(Bill bill) {
        this.bill = bill;
    }

    @Override
    public Bill execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.billInvorker.getBillService().prepareFilter(this.bill);
        this.billInvorker.getBillService().createBillFilter(this.bill);
        this.prepareForPur(this.bill);
        return this.bill;
    }

    private void prepareForPur(Bill bill) {
        ImportVoucherVo importVoucherVo = new ImportVoucherVo(bill.getSupCompanySapCode(), bill.getPostingStartTime(), bill.getPostingEndTime());
        SapImportCommand cmd = new SapImportCommand(importVoucherVo);
        this.billInvorker.invoke(cmd);
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andSupCompanySapCodeEqualTo(bill.getSupCompanySapCode()).andPostingTimeBetween(bill.getPostingStartTime(), bill.getPostingEndTime()).andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andBillTypeIsNotNull();
        List billVoucherList = this.billInvorker.getBillVoucherService().queryAllObjByExample((IExample)billVoucherExample);
        Assert.isNotEmpty((Collection)billVoucherList, (String)"\u6682\u65f6\u8fd8\u6ca1\u6709\u5b58\u5728\u9700\u8981\u5bf9\u8d26\u7684\u5165\u9000\u5e93\u51ed\u8bc1\uff01");
        this.assembleForPur(bill, billVoucherList);
    }

    private void assembleForPur(Bill bill, List<BillVoucher> billVoucherList) {
        BillUtil.setPurCompanyInfo(this.getProject(), bill, this.billInvorker.getCompanyService());
        BillUtil.setSupCompanyInfo(bill.getSupCompanySapCode(), bill, this.billInvorker.getCompanyService());
        bill.setProjectId(this.getProject().getId());
        bill.setPostingStartTime(bill.getPostingStartTime());
        bill.setPostingEndTime(bill.getPostingEndTime());
        bill.setCreateTime(new Date());
        bill.setPurUserId(this.getPurUser().getId());
        bill.setPurUserName(this.getPurUser().getNickName());
        bill.setIsEnable(Constant.YES_INT);
        bill.setSendSapFlag(Constant.NO_INT);
        bill.setCreateBillType(CreateBillType.PUR.getType());
        bill.setPurSendStatus(BillSendStatus.NO_INT);
        bill.setPurConfirmBillStatus(Constant.NO_INT);
        bill.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_UNCONFIRM.getConfirmStatus());
        bill.setSupConfirmBillStatus(Constant.NO_INT);
        bill.setApproveStatus(ApproveStatusEnum.NOT_AUDITED.getCode());
        bill.setSupSendStatus(BillSendStatus.NO);
        bill.setPurConfirmStatus(BillStatusConfirmEnum.NO.getConfirmStatus());
        CalculateBillUtil.calculateAmount(bill, billVoucherList);
    }
}

