/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.service.GenPreInvoiceService;
import com.els.base.bill.utils.ApproveStatusEnum;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.AbstractResultVO;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class SendInvoiceCommand
extends AbstractBillCommand<String> {
    private List<Bill> billList;

    public SendInvoiceCommand() {
    }

    public SendInvoiceCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.billList = this.validate(this.billList);
        GenPreInvoiceService genPreInvoiceService = (GenPreInvoiceService)SpringContextHolder.getOneBean(GenPreInvoiceService.class);
        for (Bill bill : this.billList) {
            AbstractResultVO abstractResultVO = genPreInvoiceService.writeBillInvoiceToSap(bill);
            if (abstractResultVO.getCode() != AbstractResultVO.CodeEnum.ERROR.getValue()) continue;
            throw new CommonException(abstractResultVO.getMessage());
        }
        this.billInvorker.getBillService().updateSendSapFlag(this.billList, Constant.YES_INT);
        return null;
    }

    private List<Bill> validate(List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u8bf7\u52fe\u9009\u9700\u8981\u53d1\u9001\u7684\u5355\u636e!");
        ArrayList<String> ids = new ArrayList<String>();
        for (Bill bill : billList) {
            Assert.isNotBlank((String)bill.getId(), (String)"\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            ids.add(bill.getId());
        }
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT);
        List list = this.billInvorker.getBillService().queryAllObjByExample((IExample)billExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new CommonException("\u5f00\u7968\u6e05\u5355\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\uff01");
        }
        for (Bill bill : list) {
            if (!bill.getApproveStatus().equals(ApproveStatusEnum.AUDITED.getCode())) {
                throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u542b\u6709\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5199\u5165SAP\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            }
            if (!bill.getSendSapFlag().equals(Constant.YES_INT)) continue;
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u542b\u6709\u5df2\u5199\u5165\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5199\u5165SAP\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
        return list;
    }
}

