/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.els.base.bill.command.SupCreateCommand;
import com.els.base.bill.utils.BillUtil;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.vo.BillVoucherVo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class SupExcelImportCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(SupExcelImportCommand.class);
    private MultipartFile file;
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public SupExcelImportCommand(MultipartFile file) {
        this.file = file;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        List<BillVoucher> billVoucherList = this.check(this.file);
        if (!CollectionUtils.isNotEmpty(billVoucherList)) {
            throw new CommonException("\u6ca1\u6709\u53ef\u4ee5\u64cd\u4f5c\u7684\u51ed\u8bc1\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        SupCreateCommand supCreateCommand = new SupCreateCommand(billVoucherList);
        supCreateCommand.setProject(this.getProject());
        supCreateCommand.setSupCompany(this.getSupCompany());
        supCreateCommand.setSupUser(this.getSupUser());
        this.billInvorker.invoke(supCreateCommand);
        return null;
    }

    private List<BillVoucher> check(MultipartFile file) {
        Assert.isNotNull((Object)file, (String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ExcelImportResult result = null;
        try {
            ImportParams importParams = new ImportParams();
            result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), BillVoucherVo.class, (ImportParams)importParams);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new CommonException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u662f\u52a0\u5bc6\u6587\u4ef6\uff0c\u6216\u8005\u5df2\u7ecf\u662f\u635f\u574f\u7684\u6587\u4ef6\uff01");
        }
        List list = result.getList();
        int index = 1;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (BillVoucherVo billVoucherVo : list) {
                Iterator iterator;
                ++index;
                Set set = this.validator.validate((Object)billVoucherVo, new Class[0]);
                if (!CollectionUtils.isNotEmpty((Collection)set) || !(iterator = set.iterator()).hasNext()) continue;
                ConstraintViolation constraintViolation = (ConstraintViolation)iterator.next();
                throw new CommonException("\u8bf7\u68c0\u67e5\u7b2c" + index + "\u884c\u7684\u6570\u636e\uff1a" + constraintViolation.getMessage());
            }
        }
        List successList = result.getList();
        List failList = result.getFailList();
        this.logger.info("\u662f\u5426\u5b58\u5728\u9a8c\u8bc1\u672a\u901a\u8fc7\u7684\u6570\u636e:" + result.isVerfiyFail());
        this.logger.info("\u9a8c\u8bc1\u901a\u8fc7\u7684\u6570\u91cf:" + successList.size());
        this.logger.info("\u9a8c\u8bc1\u672a\u901a\u8fc7\u7684\u6570\u91cf:" + failList.size());
        if (result.isVerfiyFail()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < failList.size(); ++i) {
                stringBuffer.append(i + ":\u7269\u6599\u51ed\u8bc1\u53f7\u4e3a\uff1a" + ((BillVoucherVo)failList.get(i)).getMaterialVoucherNo() + "\u884c\u53f7\u4e3a\uff1a" + ((BillVoucherVo)failList.get(i)).getMaterialVoucherItemNo() + ";");
            }
            throw new CommonException("\u8bf7\u68c0\u67e5\uff1a" + stringBuffer);
        }
        String companySapCode = this.getSupCompany().getCompanySapCode();
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andSwitchFlagEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(companySapCode);
        List billSwitches = this.billInvorker.getBillSwitchService().queryAllObjByExample((IExample)billSwitchExample);
        ArrayList<BillVoucher> billVoucherList = new ArrayList<BillVoucher>();
        for (BillVoucherVo billVoucherVo : successList) {
            BillVoucherExample billVoucherExample = new BillVoucherExample();
            billVoucherExample.createCriteria().andSupCompanySapCodeEqualTo(this.getSupCompany().getCompanySapCode()).andIsEnableEqualTo(Constant.YES_INT).andMaterialVoucherNoEqualTo(billVoucherVo.getMaterialVoucherNo()).andMaterialVoucherItemNoEqualTo(billVoucherVo.getMaterialVoucherItemNo());
            List billVouchers = this.billInvorker.getBillVoucherService().queryAllObjByExample((IExample)billVoucherExample);
            Assert.isNotEmpty((Collection)billVouchers, (String)("\u7269\u6599\u51ed\u8bc1\u53f7\uff1a" + billVoucherVo.getMaterialVoucherNo() + ",\u7269\u6599\u51ed\u8bc1\u884c\u53f7\uff1a" + billVoucherVo.getMaterialVoucherItemNo() + ",\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            BillVoucher billVoucher = (BillVoucher)billVouchers.get(0);
            if (Constant.YES_INT.equals(billVoucher.getBillFlag())) {
                throw new CommonException("\u7269\u6599\u51ed\u8bc1\u53f7\uff1a" + billVoucherVo.getMaterialVoucherNo() + ",\u7269\u6599\u51ed\u8bc1\u884c\u53f7\uff1a" + billVoucherVo.getMaterialVoucherItemNo() + ",\u5df2\u7ecf\u5bf9\u8fc7\u8d26\u4e86\uff0c\u8bf7\u68c0\u67e5");
            }
            BillUtil.checkBillTime(billSwitches, billVoucher.getPostingTime());
            billVoucherList.add(billVoucher);
        }
        return billVoucherList;
    }
}

