/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.vo.BillItemExportExcelVo;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;

public class SupExportCommand
extends AbstractBillCommand<FileData> {
    QueryParamWapper wapper;

    public SupExportCommand() {
    }

    public SupExportCommand(QueryParamWapper wapper) {
        this.wapper = wapper;
    }

    @Override
    public FileData execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validData(this.wapper);
        return this.processor(this.wapper);
    }

    private FileData processor(QueryParamWapper wapper) {
        BillExample example = new BillExample();
        BillExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(this.getSupCompany().getId()).andProjectIdEqualTo(this.getProject().getId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List billList = this.billInvorker.getBillService().queryAllObjByExample((IExample)example);
        FileData fileData = new FileData();
        try {
            fileData = this.getFileData(billList);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff01");
        }
        return fileData;
    }

    private FileData getFileData(List<Bill> billList) throws IOException {
        FileData fileData = new FileData();
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        fileData.setProjectId(this.getProject().getId());
        fileData.setCompanyId(this.getSupCompany().getId());
        fileData.setFileName(MessageFormat.format("\u5f00\u7968\u6e05\u5355\u884c-{0}", dateStr) + ".xls");
        fileData.setFileSuffix("xls");
        fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
        fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
        FileOutputStream fos = new FileOutputStream(fileData.toFile());
        if (CollectionUtils.isEmpty(billList)) {
            return fileData;
        }
        List<BillItem> billItems = this.getBillItemList(billList);
        ArrayList<BillItemExportExcelVo> billItemExportExcelVos = new ArrayList<BillItemExportExcelVo>();
        if (CollectionUtils.isEmpty(billItems)) {
            return fileData;
        }
        for (BillItem billItem : billItems) {
            BillItemExportExcelVo billItemExportExcelVo = new BillItemExportExcelVo();
            BeanUtils.copyProperties((Object)billItem, (Object)billItemExportExcelVo);
            billItemExportExcelVos.add(billItemExportExcelVo);
        }
        ExportParams params = new ExportParams();
        params.setSheetName("\u5f00\u7968\u6e05\u5355\u884c");
        params.setType(ExcelType.HSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, BillItemExportExcelVo.class, billItemExportExcelVos);
        workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
        return fileData;
    }

    private List<BillItem> getBillItemList(List<Bill> billList) {
        List billIdList = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillIdIn(billIdList).andIsEnableEqualTo(Constant.YES_INT);
        return this.billInvorker.getBillItemService().queryAllObjByExample((IExample)billItemExample);
    }

    private void validData(QueryParamWapper wapper) {
    }
}

