/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bill.command.ApproveCommand;
import com.els.base.bill.command.CreateCommand;
import com.els.base.bill.command.DeleteCommand;
import com.els.base.bill.command.ExportCommand;
import com.els.base.bill.command.PurAbolishCommand;
import com.els.base.bill.command.PurConfirmCommand;
import com.els.base.bill.command.PurExcelImportCommand;
import com.els.base.bill.command.PurPrepareCommand;
import com.els.base.bill.command.PurRejectCommand;
import com.els.base.bill.command.PurSendCommand;
import com.els.base.bill.command.PurSignCommand;
import com.els.base.bill.command.SendInvoiceCommand;
import com.els.base.bill.command.SupAbolishCommand;
import com.els.base.bill.command.SupConfirmCommand;
import com.els.base.bill.command.SupExcelImportCommand;
import com.els.base.bill.command.SupExportCommand;
import com.els.base.bill.command.SupPrepareCommand;
import com.els.base.bill.command.SupRejectCommand;
import com.els.base.bill.command.SupSendCommand;
import com.els.base.bill.command.SupSignCommand;
import com.els.base.bill.command.SupUpdateCommand;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.service.BillService;
import com.els.base.common.BillInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.service.BillInvoiceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u6570\u636e")
@Controller
@RequestMapping(value={"bill"})
public class BillController {
    @Resource
    private BillService billService;
    @Resource
    private CompanyPurRefService companyPurRefService;
    @Resource
    private BillInvoiceService billInvoiceService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod="POST", value="\u624b\u52a8\u53d1\u9001\u9884\u5236\u53d1\u7968\u5230sap")
    @RequestMapping(value={"service/sendInvoiceToSap"})
    @ResponseBody
    public ResponseResult<String> sendInvoiceToSap(@RequestBody(required=true) List<Bill> billList) {
        SendInvoiceCommand cmd = new SendInvoiceCommand(billList);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u51fa\u5bf9\u8d26\u6e05\u5355\u6570\u636e", httpMethod="POST")
    @RequestMapping(value={"service/exportBill", "service/pur/exportBill"})
    @ResponseBody
    public ResponseResult<FileData> exportBill(@RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        ExportCommand cmd = new ExportCommand(wapper);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(value="\u5bfc\u51fa\u5bf9\u8d26\u6e05\u5355\u6570\u636e", httpMethod="POST")
    @RequestMapping(value={"service/sup/exportBill"})
    @ResponseBody
    public ResponseResult<FileData> supExportBill(@RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        SupExportCommand cmd = new SupExportCommand(wapper);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u521b\u5efa\u5f00\u7968\u6e05\u5355\u9884\u89c8\u6570\u636e")
    @RequestMapping(value={"service/pur/prepare"})
    @ResponseBody
    public ResponseResult<Bill> prepareForPur(@RequestBody Bill bill) {
        PurPrepareCommand cmd = new PurPrepareCommand(bill);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        Bill newBill = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)newBill);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u521b\u5efa\u5f00\u7968\u6e05\u5355\u9884\u89c8\u6570\u636e")
    @RequestMapping(value={"service/sup/prepare"})
    @ResponseBody
    public ResponseResult<Bill> prepareForSup(@RequestBody Bill bill) {
        SupPrepareCommand cmd = new SupPrepareCommand(bill);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        Bill newBill = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)newBill);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u521b\u5efa\u5f00\u7968\u6e05\u5355\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Bill bill) {
        CreateCommand cmd = new CreateCommand(bill);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u6279\u91cf\u5220\u9664\u5f00\u7968\u6e05\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<Bill> billList) {
        DeleteCommand cmd = new DeleteCommand(billList);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u67e5\u8be2\u91c7\u8d2d\u5f00\u7968\u6e05\u5355\u8be6\u60c5")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<Bill> findDetailById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        Bill bill = (Bill)this.billService.queryObjById(id);
        return ResponseResult.success((Object)bill);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u53d1\u9001\u5f00\u7968\u6e05\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/pur/send"})
    @ResponseBody
    public ResponseResult<String> sendForPur(@RequestBody(required=true) List<Bill> billList) {
        PurSendCommand cmd = new PurSendCommand(billList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u53d1\u9001\u5f00\u7968\u6e05\u5355\u7ed9\u91c7\u8d2d\u5458")
    @RequestMapping(value={"service/sup/send"})
    @ResponseBody
    public ResponseResult<String> sendForSup(@RequestBody(required=true) List<Bill> billList) {
        SupSendCommand cmd = new SupSendCommand(billList);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u786e\u8ba4\u5355\u636e")
    @RequestMapping(value={"service/sup/confirm"})
    @ResponseBody
    public ResponseResult<String> confirmForSup(@RequestBody(required=true) List<Bill> billList) {
        SupConfirmCommand cmd = new SupConfirmCommand(billList);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u7f16\u8f91\u5355\u636e")
    @RequestMapping(value={"service/sup/updateForSup"})
    @ResponseBody
    public ResponseResult<String> updateForSup(@RequestBody(required=true) Bill bill) {
        SupUpdateCommand cmd = new SupUpdateCommand(bill);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u56de\u7b7e\uff0c\u786e\u8ba4\u53d1\u7968\u6ca1\u6709\u95ee\u9898")
    @RequestMapping(value={"service/sup/sign"})
    @ResponseBody
    public ResponseResult<String> signForSup(@RequestBody(required=true) List<Bill> billList) {
        SupSignCommand cmd = new SupSignCommand(billList);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u786e\u8ba4\u5355\u636e\u53d1\u7968\u6ca1\u6709\u95ee\u9898")
    @RequestMapping(value={"service/pur/sign"})
    @ResponseBody
    public ResponseResult<String> signForPur(@RequestBody(required=true) List<Bill> billList) {
        PurSignCommand cmd = new PurSignCommand(billList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u786e\u8ba4\u5355\u636e")
    @RequestMapping(value={"service/pur/confirm"})
    @ResponseBody
    public ResponseResult<String> confirmForPur(@RequestBody(required=true) List<Bill> billList) {
        PurConfirmCommand cmd = new PurConfirmCommand(billList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u62d2\u7edd\u5355\u636e")
    @RequestMapping(value={"service/pur/reject"})
    @ResponseBody
    public ResponseResult<String> rejectForPur(@RequestBody(required=true) List<Bill> billList) {
        PurRejectCommand cmd = new PurRejectCommand(billList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u62d2\u7edd\u5355\u636e")
    @RequestMapping(value={"service/sup/reject"})
    @ResponseBody
    public ResponseResult<String> rejectForSup(@RequestBody(required=true) List<Bill> billList) {
        SupRejectCommand cmd = new SupRejectCommand(billList);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u4f5c\u5e9f\u5355\u636e")
    @RequestMapping(value={"service/pur/abolish"})
    @ResponseBody
    public ResponseResult<String> abolishForPur(@RequestBody(required=true) List<Bill> billList) {
        PurAbolishCommand cmd = new PurAbolishCommand(billList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u4f5c\u5e9f\u5355\u636e")
    @RequestMapping(value={"service/sup/abolish"})
    @ResponseBody
    public ResponseResult<String> abolishForSup(@RequestBody(required=true) List<Bill> billList) {
        SupAbolishCommand cmd = new SupAbolishCommand(billList);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u91c7\u8d2d\u5458\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/sendApprove"})
    @ResponseBody
    public ResponseResult<String> sendApprove(@RequestBody(required=true) List<Bill> billList) {
        ApproveCommand cmd = new ApproveCommand(billList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u5206\u9875\u67e5\u8be2\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Bill", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Bill>> findForSupByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillExample example = new BillExample();
        example.setPageView((PageView<Bill>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andProjectIdEqualTo(ProjectUtils.getProjectId()).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andPurSendStatusNotEqualTo(Constant.NO_INT).andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billService.queryObjByPage((IExample)example);
        List<Bill> queryResult = this.getBillList(pageData.getQueryResult());
        pageData = pageData.setQueryResult(queryResult);
        return ResponseResult.success((Object)pageData);
    }

    private List<Bill> getBillList(List<Bill> billList) {
        ArrayList<Bill> billTempList = new ArrayList<Bill>();
        if (CollectionUtils.isEmpty(billList)) {
            return billTempList;
        }
        for (Bill bill : billList) {
            List<BillInvoice> billInvoiceList = this.billInvoiceService.queryByBillId(bill.getId());
            bill.setInvoiceList(billInvoiceList);
            billTempList.add(bill);
        }
        return billTempList;
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5458\u5206\u9875\u67e5\u8be2\u5f00\u7968\u6e05\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Bill", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Bill>> findForPurByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        ArrayList<String> sapCompanyList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)companyList)) {
            for (Company c : companyList) {
                sapCompanyList.add(c.getCompanySapCode());
            }
        } else {
            PageView billPageView = new PageView();
            billPageView.setQueryResult(new ArrayList());
            return ResponseResult.success((Object)billPageView);
        }
        BillExample example = new BillExample();
        example.setPageView((PageView<Bill>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andProjectIdEqualTo(ProjectUtils.getProjectId()).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andSupSendStatusNotEqualTo(Constant.NO_INT).andSupCompanySapCodeIn(sapCompanyList);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billService.queryObjByPage((IExample)example);
        List<Bill> queryResult = this.getBillList(pageData.getQueryResult());
        pageData = pageData.setQueryResult(queryResult);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u901a\u8fc7Excel\u5bfc\u5165\u51ed\u8bc1\uff0c\u65b0\u5efa\u5f00\u7968\u6e05\u5355")
    @PostMapping(value={"service/sup/import"})
    @ResponseBody
    public ResponseResult<String> importExcelForSup(@RequestParam(value="file", required=true) MultipartFile file) {
        SupExcelImportCommand cmd = new SupExcelImportCommand(file);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success((Object)"\u521b\u5efa\u6210\u529f\uff0c\u8bf7\u5230\u5f00\u7968\u6e05\u5355\u5217\u8868\u67e5\u770b\uff01");
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u901a\u8fc7Excel\u5bfc\u5165\u51ed\u8bc1\uff0c\u65b0\u5efa\u5f00\u7968\u6e05\u5355")
    @PostMapping(value={"service/pur/import"})
    @ResponseBody
    public ResponseResult<String> importExcelForPur(@RequestParam(value="file", required=true) MultipartFile file) {
        PurExcelImportCommand cmd = new PurExcelImportCommand(file);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success((Object)"\u521b\u5efa\u6210\u529f\uff0c\u8bf7\u5230\u5f00\u7968\u6e05\u5355\u5217\u8868\u67e5\u770b\uff01");
    }
}

