/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.service.impl;

import com.els.base.bill.dao.BillMapper;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.bill.service.BillService;
import com.els.base.bill.service.GenPreInvoiceService;
import com.els.base.bill.utils.ApproveStatusEnum;
import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.billswitch.service.BillSwitchService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.service.BillInvoiceService;
import com.els.base.utils.AbstractResultVO;
import com.els.base.utils.SpringContextHolder;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillService")
public class BillServiceImpl
implements BillService,
ITaskListener {
    Logger logger = LoggerFactory.getLogger(BillServiceImpl.class);
    @Resource
    protected BillMapper billMapper;
    @Resource
    protected BillVoucherService billVoucherService;
    @Resource
    protected BillItemService billItemService;
    @Resource
    private BillSwitchService billSwitchService;
    @Resource
    private BillInvoiceService billInvoiceService;

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void deleteByExample(BillExample example) {
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u4e0d\u80fd\u8fdb\u884c\u5168\u8868\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.billMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    public int updateByExampleSelective(Bill record, BillExample example) {
        Assert.isNotNull((Object)record);
        return this.billMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public int countByExample(BillExample example) {
        return this.billMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public int updateSendSapFlag(List<Bill> billList, Integer flag) {
        Assert.isNotEmpty(billList, (String)"\u5bf9\u8d26\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)flag, (String)"\u6807\u8bc6\u7b26\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        Bill bill = new Bill();
        bill.setSendSapFlag(flag);
        int i = 0;
        if (this.billMapper.countByExample(billExample) > 0) {
            i = this.billMapper.updateByExampleSelective(bill, billExample);
        }
        return i;
    }

    @Override
    public void createBillFilter(Bill bill) {
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(bill.getSupCompanySapCode()).andSwitchFlagEqualTo(Constant.YES_INT);
        List billSwitches = this.billSwitchService.queryAllObjByExample((IExample)billSwitchExample);
        if (CollectionUtils.isNotEmpty((Collection)billSwitches)) {
            for (BillSwitch billSwitch : billSwitches) {
                if (CollectionUtils.isEmpty((Collection)billSwitches)) continue;
                Assert.isNotNull((Object)billSwitch);
                Integer switchFlag = billSwitch.getSwitchFlag();
                Assert.isNotNull((Object)switchFlag, (String)"\u5f00\u8d26\u65f6\u95f4\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                if (switchFlag.equals(Constant.NO_INT)) continue;
                Integer startTime = billSwitch.getStartTime();
                Integer endTime = billSwitch.getEndTime();
                Assert.isNotNull((Object)startTime, (String)"\u5f00\u7968\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Assert.isNotNull((Object)endTime, (String)"\u5f00\u7968\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.logger.info("\u91c7\u8d2d\u5458\u8bbe\u7f6e\u7684\u5f00\u7968\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a{}", (Object)startTime);
                this.logger.info("\u91c7\u8d2d\u5458\u8bbe\u7f6e\u7684\u5f00\u7968\u7ed3\u675f\u65f6\u95f4\u4e3a\uff1a{}", (Object)endTime);
                Calendar calendar = Calendar.getInstance();
                int date = calendar.get(5);
                this.logger.info("\u7cfb\u7edf\u5f53\u524d\u5929\u6570\u4e3a\uff1a{}", (Object)date);
                if (date >= startTime && date <= endTime) continue;
                throw new CommonException("\u4e0d\u5728\u5bf9\u8d26\u65f6\u95f4\u5185,\u8bf7\u8054\u7cfb\u91c7\u8d2d\u5458\u8bbe\u7f6e\u5bf9\u8d26\u65f6\u95f4\uff0c\u8c22\u8c22\uff01");
            }
        }
    }

    @Override
    public void prepareFilter(Bill bill) {
        Assert.isNotNull((Object)bill, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String supCompanySapCode = bill.getSupCompanySapCode();
        Date postingStartTime = bill.getPostingStartTime();
        Date postingEndTime = bill.getPostingEndTime();
        Assert.isNotBlank((String)supCompanySapCode, (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)postingStartTime, (String)"\u51ed\u8bc1\u5f00\u59cb\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)postingEndTime, (String)"\u51ed\u8bc1\u7ed3\u675f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (bill.getPostingStartTime().getTime() > bill.getPostingEndTime().getTime()) {
            throw new CommonException("\u51ed\u8bc1\u5f00\u59cb\u65e5\u4e0d\u80fd\u5927\u4e8e\u51ed\u8bc1\u7ed3\u675f\u65e5,\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\uff0c\u8c22\u8c22\uff01");
        }
        this.checkBillSwitch(supCompanySapCode, postingStartTime, postingEndTime);
    }

    private void checkBillSwitch(String supCompanySapCode, Date postingStartTime, Date postingEndTime) {
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(supCompanySapCode);
        List billSwitches = this.billSwitchService.queryAllObjByExample((IExample)billSwitchExample);
        if (CollectionUtils.isNotEmpty((Collection)billSwitches)) {
            for (BillSwitch billSwitch : billSwitches) {
                boolean b1;
                if (CollectionUtils.isEmpty((Collection)billSwitches) || billSwitch == null || billSwitch.getSwitchFlag().equals(Constant.NO_INT)) continue;
                Date voucherStartTime = billSwitch.getVoucherStartTime();
                Date voucherEndTime = billSwitch.getVoucherEndTime();
                if (voucherStartTime == null && voucherEndTime == null || voucherStartTime != null && voucherEndTime == null || voucherStartTime == null || voucherEndTime == null) continue;
                String str = DateFormatUtils.format((Date)voucherStartTime, (String)"yyyy-MM-dd");
                String str2 = DateFormatUtils.format((Date)voucherEndTime, (String)"yyyy-MM-dd");
                this.logger.info("\u7528\u6237\u4f20\u7684\u51ed\u8bc1\u5f00\u59cb\u65e5:{}", (Object)DateFormatUtils.format((Date)postingStartTime, (String)"yyyy-MM-dd"));
                this.logger.info("\u7528\u6237\u4f20\u7684\u51ed\u8bc1\u7ed3\u675f\u65e5:{}", (Object)DateFormatUtils.format((Date)postingEndTime, (String)"yyyy-MM-dd"));
                this.logger.info("\u91c7\u8d2d\u8bbe\u7f6e\u7684\u51ed\u8bc1\u5f00\u59cb\u65e5\uff1a{}", (Object)str);
                this.logger.info("\u91c7\u8d2d\u8bbe\u7f6e\u7684\u51ed\u8bc1\u7ed3\u675f\u65e5\uff1a{}", (Object)str2);
                Date postingStartTime1 = DateUtils.truncate((Date)postingStartTime, (int)5);
                Date postingEndTime1 = DateUtils.truncate((Date)postingEndTime, (int)5);
                Date voucherStartTime1 = DateUtils.truncate((Date)voucherStartTime, (int)5);
                Date voucherEndTime1 = DateUtils.truncate((Date)voucherEndTime, (int)5);
                boolean b = postingStartTime1.getTime() >= voucherStartTime1.getTime();
                boolean bl = b1 = postingEndTime1.getTime() <= voucherEndTime1.getTime();
                if (b && b1) continue;
                throw new CommonException("\u4f60\u6240\u9009\u7684\u5bf9\u8d26\u51ed\u8bc1\u65f6\u95f4\u4e0d\u5728\u65f6\u95f4\u89c4\u5b9a\u8303\u56f4\u5185,\u5141\u8bb8\u65f6\u95f4\u4e3a\uff1a" + str + "\u5230" + str2);
            }
        }
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        block8: {
            if (event == null) {
                return;
            }
            String businessId = event.getBusinessId();
            if (StringUtils.isBlank((String)businessId)) {
                return;
            }
            Bill bill = this.billMapper.selectByPrimaryKey(businessId);
            if (bill == null) {
                return;
            }
            if (event.isFinished() && event.isPass()) {
                try {
                    bill.setApproveTime(new Date());
                    bill.setApproveStatus(ApproveStatusEnum.AUDITED.getCode());
                    bill.setSendSapFlag(Constant.YES_INT);
                    bill.setInvoiceSignFlag(Constant.YES_INT);
                    this.billMapper.updateByPrimaryKeySelective(bill);
                    this.updateBillVoucher(bill, Constant.YES_INT);
                    GenPreInvoiceService genPreInvoiceService = (GenPreInvoiceService)SpringContextHolder.getOneBean(GenPreInvoiceService.class);
                    AbstractResultVO abstractResultVO = genPreInvoiceService.writeBillInvoiceToSap(bill);
                    if (abstractResultVO.getCode() == AbstractResultVO.CodeEnum.ERROR.getValue()) {
                        this.logger.info("\u5f80SAP\u5199\u5165\u53d1\u7968\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a:{}", (Object)abstractResultVO.getMessage());
                        throw new CommonException(abstractResultVO.getMessage());
                    }
                    break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.info("\u5f80SAP\u5199\u5165\u53d1\u7968\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a:{}", (Object)e.getMessage());
                    throw new CommonException(e.getMessage());
                }
            }
            if (event.isFinished() && !event.isPass()) {
                bill.setApproveTime(new Date());
                bill.setApproveStatus(ApproveStatusEnum.DISMISSAL.getCode());
                this.billMapper.updateByPrimaryKeySelective(bill);
                this.updateBillVoucher(bill, Constant.NO_INT);
                ArrayList<String> billIdList = new ArrayList<String>();
                billIdList.add(businessId);
                this.billInvoiceService.updateBillInvoiceFlag(billIdList, Constant.NO_INT);
            }
        }
    }

    private void updateBillVoucher(Bill bill, Integer billFlag) {
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillIdEqualTo(bill.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List billItems = this.billItemService.queryAllObjByExample((IExample)billItemExample);
        Assert.isNotEmpty((Collection)billItems, (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5bf9\u8d26\u51ed\u8bc1\u884c\u4e0d\u5b58\u5728\uff01");
        for (BillItem billItem : billItems) {
            BillVoucher voucher = new BillVoucher();
            voucher.setId(billItem.getVoucherId());
            voucher.setBillFlag(billFlag);
            this.billVoucherService.modifyObj(voucher);
        }
    }

    @Override
    public void updateVoucherByBillIds(List<String> ids, int billFlag) {
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        List billItems = this.billItemService.queryAllObjByExample((IExample)billItemExample);
        if (CollectionUtils.isEmpty((Collection)billItems)) {
            return;
        }
        ArrayList<String> voucherIds = new ArrayList<String>();
        for (BillItem billItem : billItems) {
            voucherIds.add(billItem.getVoucherId());
        }
        if (CollectionUtils.isEmpty(voucherIds)) {
            return;
        }
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andIdIn(voucherIds);
        int i = this.billVoucherService.countByExample(billVoucherExample);
        if (i > 0) {
            BillVoucher billVoucher = new BillVoucher();
            billVoucher.setBillFlag(billFlag);
            this.billVoucherService.updateByExampleSelective(billVoucher, billVoucherExample);
        }
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    public void addObj(Bill t) {
        this.billMapper.insertSelective(t);
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"bill"}, allEntries=true)
    public void modifyObj(Bill t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public Bill queryObjById(String id) {
        return this.billMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public List<Bill> queryAllObjByExample(BillExample example) {
        return this.billMapper.selectByExample(example);
    }

    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public PageView<Bill> queryObjByPage(BillExample example) {
        PageView<Bill> pageView = example.getPageView();
        pageView.setQueryResult(this.billMapper.selectByExampleByPage(example));
        return pageView;
    }
}

