/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.utils;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillItem;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.voucher.entity.BillVoucher;
import java.math.BigDecimal;
import java.util.List;

public class CalculateBillUtil {
    public static Bill calculateAmount(Bill bill, List<BillVoucher> billVoucherList) {
        BigDecimal notIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal includeTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal rebateNotIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal rebateIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal rebateTaxAmount = BigDecimal.ZERO;
        for (BillVoucher billVoucher : billVoucherList) {
            String billType;
            Assert.isNotNull((Object)billVoucher, (String)"\u5165\u9000\u5e93\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotNull((Object)billVoucher.getNotIncludeTaxAmount(), (String)"\u5f00\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotNull((Object)billVoucher.getIncludeTaxAmount(), (String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotNull((Object)billVoucher.getTaxAmount(), (String)"\u5f00\u7968\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotBlank((String)billVoucher.getBillType(), (String)"\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            switch (billType = billVoucher.getBillType()) {
                case "101": {
                    notIncludeTaxAmount = notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.add(billVoucher.getTaxAmount());
                    break;
                }
                case "102": {
                    notIncludeTaxAmount = notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                }
                case "122": {
                    notIncludeTaxAmount = notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                }
                case "123": {
                    notIncludeTaxAmount = notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.add(billVoucher.getTaxAmount());
                    break;
                }
                case "161": {
                    notIncludeTaxAmount = notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                }
                case "162": {
                    notIncludeTaxAmount = notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.add(billVoucher.getTaxAmount());
                    break;
                }
            }
            if (billVoucher.getIsRebate() == null || !billVoucher.getIsRebate().equals(Constant.YES_INT)) continue;
            BigDecimal rebateNotIncludeTaxAmount1 = billVoucher.getRebateNotIncludeTaxAmount();
            if (rebateNotIncludeTaxAmount1 == null) {
                rebateNotIncludeTaxAmount1 = BigDecimal.ZERO;
            }
            rebateNotIncludeTaxAmount = rebateNotIncludeTaxAmount.add(rebateNotIncludeTaxAmount1);
            BigDecimal rebateIncludeTaxAmount1 = billVoucher.getRebateIncludeTaxAmount();
            if (rebateIncludeTaxAmount1 == null) {
                rebateIncludeTaxAmount1 = BigDecimal.ZERO;
            }
            rebateIncludeTaxAmount = rebateIncludeTaxAmount.add(rebateIncludeTaxAmount1);
            BigDecimal rebateTaxAmount1 = billVoucher.getRebateTaxAmount();
            if (rebateTaxAmount1 == null) {
                rebateTaxAmount1 = BigDecimal.ZERO;
            }
            rebateTaxAmount = rebateTaxAmount.add(rebateTaxAmount1);
        }
        bill.setIncludeTaxAmount(includeTaxAmount);
        bill.setNotIncludeTaxAmount(notIncludeTaxAmount);
        bill.setTaxAmount(taxAmount);
        bill.setRebateIncludeTaxAmount(rebateIncludeTaxAmount);
        bill.setRebateNotIncludeTaxAmount(rebateNotIncludeTaxAmount);
        bill.setRebateTaxAmount(rebateTaxAmount);
        BigDecimal deductionAmount = rebateIncludeTaxAmount;
        bill.setDeductionAmount(deductionAmount);
        bill.setTotalAmount(includeTaxAmount);
        return bill;
    }

    public static void calculateInvoiceAmount(BillInvoice billInvoice, List<BillItem> billItemList) {
        BigDecimal notIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal includeTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal rebateNotIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal rebateIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal rebateTaxAmount = BigDecimal.ZERO;
        for (BillItem billVoucher : billItemList) {
            String billType;
            Assert.isNotNull((Object)billVoucher, (String)"\u5165\u9000\u5e93\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotNull((Object)billVoucher.getNotIncludeTaxAmount(), (String)"\u5f00\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotNull((Object)billVoucher.getIncludeTaxAmount(), (String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotNull((Object)billVoucher.getTaxAmount(), (String)"\u5f00\u7968\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotBlank((String)billVoucher.getBillType(), (String)"\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            switch (billType = billVoucher.getBillType()) {
                case "101": {
                    notIncludeTaxAmount = notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.add(billVoucher.getTaxAmount());
                    break;
                }
                case "102": {
                    notIncludeTaxAmount = notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                }
                case "122": {
                    notIncludeTaxAmount = notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                }
                case "123": {
                    notIncludeTaxAmount = notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.add(billVoucher.getTaxAmount());
                    break;
                }
                case "161": {
                    notIncludeTaxAmount = notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                }
                case "162": {
                    notIncludeTaxAmount = notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount = includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount = taxAmount.add(billVoucher.getTaxAmount());
                    break;
                }
            }
            if (billVoucher.getIsRebate() == null || !billVoucher.getIsRebate().equals(Constant.YES_INT)) continue;
            BigDecimal rebateNotIncludeTaxAmount1 = billVoucher.getRebateNotIncludeTaxAmount();
            if (rebateNotIncludeTaxAmount1 == null) {
                rebateNotIncludeTaxAmount1 = BigDecimal.ZERO;
            }
            rebateNotIncludeTaxAmount = rebateNotIncludeTaxAmount.add(rebateNotIncludeTaxAmount1);
            BigDecimal rebateIncludeTaxAmount1 = billVoucher.getRebateIncludeTaxAmount();
            if (rebateIncludeTaxAmount1 == null) {
                rebateIncludeTaxAmount1 = BigDecimal.ZERO;
            }
            rebateIncludeTaxAmount = rebateIncludeTaxAmount.add(rebateIncludeTaxAmount1);
            BigDecimal rebateTaxAmount1 = billVoucher.getRebateTaxAmount();
            if (rebateTaxAmount1 == null) {
                rebateTaxAmount1 = BigDecimal.ZERO;
            }
            rebateTaxAmount = rebateTaxAmount.add(rebateTaxAmount1);
        }
        billInvoice.setIncludeTaxAmount(includeTaxAmount);
        billInvoice.setNotIncludeTaxAmount(notIncludeTaxAmount);
        billInvoice.setTaxAmount(taxAmount);
        billInvoice.setRebateIncludeTaxAmount(rebateIncludeTaxAmount);
        billInvoice.setRebateNotIncludeTaxAmount(rebateNotIncludeTaxAmount);
        billInvoice.setRebateTaxAmount(rebateTaxAmount);
        BigDecimal deductionAmount = rebateIncludeTaxAmount;
        billInvoice.setDeductionAmount(deductionAmount);
        billInvoice.setTotalAmount(includeTaxAmount);
    }
}

