/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.category.command;

import com.els.base.category.entity.CompanyCategory;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;

public class CreateCommand
extends AbstractBillCommand<String> {
    private CompanyCategory companyCategory;

    public CreateCommand(CompanyCategory companyCategory) {
        this.companyCategory = companyCategory;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(this.companyCategory);
        this.process(this.companyCategory);
        return null;
    }

    private void process(CompanyCategory companyCategory) {
        companyCategory.setId(UUIDGenerator.generateUUID());
        companyCategory.setProjectId(this.getProject().getId());
        companyCategory.setPurCompanyId(this.getProject().getCompanyId());
        companyCategory.setPurCompanyFullName(this.getPurCompany().getCompanyFullName());
        companyCategory.setPurCompanyName(this.getPurCompany().getCompanyName());
        companyCategory.setPurCompanySapCode(this.getPurCompany().getCompanySapCode());
        companyCategory.setPurCompanySrmCode(this.getPurCompany().getCompanyCode());
        companyCategory.setPurUserId(this.getPurUser().getId());
        companyCategory.setPurUserName(this.getPurUser().getNickName());
        companyCategory.setCreateTime(new Date());
        companyCategory.setIsEnable(Constant.YES_INT);
        String nextCode = this.billInvorker.getGenerateCodeService().getNextCode("COMPANY_CATEGORY_NO");
        companyCategory.setCategoryNo(nextCode);
        this.billInvorker.getCompanyCategoryService().addObj(companyCategory);
    }

    private void check(CompanyCategory companyCategory) {
        Assert.isNotNull((Object)companyCategory, (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)companyCategory.getCategoryName(), (String)"\u4f9b\u5e94\u5546\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
    }
}

