/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.category.command;

import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.category.entity.CompanyCategoryExample;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class DeleteCommand
extends AbstractBillCommand<String> {
    private List<String> ids;

    public DeleteCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(this.ids);
        this.process(this.ids);
        return null;
    }

    private void process(List<String> ids) {
        CompanyCategoryExample example = new CompanyCategoryExample();
        example.createCriteria().andIdIn((List)ids);
        List companyCategories = this.billInvorker.getCompanyCategoryService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)companyCategories)) {
            return;
        }
        List<String> no = companyCategories.stream().map(CompanyCategory::getCategoryNo).collect(Collectors.toList());
        this.deleteCompanyCategoryRef(no);
        this.deleteCompanyCategorySwitch(no);
        this.deleteBillSwitch(no);
        this.deleteCompanyCategory(ids);
    }

    private void deleteBillSwitch(List<String> no) {
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andCategoryNoIn((List)no);
        this.billInvorker.getBillSwitchService().deleteByExample(billSwitchExample);
    }

    private void deleteCompanyCategorySwitch(List<String> no) {
        CategoryBillSwitchExample categoryBillSwitchExample = new CategoryBillSwitchExample();
        categoryBillSwitchExample.createCriteria().andCategoryNoIn((List)no);
        this.billInvorker.getCategoryBillSwitchService().deleteByExample(categoryBillSwitchExample);
    }

    private void deleteCompanyCategoryRef(List<String> no) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andCategoryNoIn((List)no);
        this.billInvorker.getCompanyCategoryRefService().deleteByExample(companyCategoryRefExample);
    }

    private void deleteCompanyCategory(List<String> ids) {
        CompanyCategoryExample companyCategoryExample = new CompanyCategoryExample();
        companyCategoryExample.createCriteria().andIdIn((List)ids);
        this.billInvorker.getCompanyCategoryService().deleteByExample(companyCategoryExample);
    }

    private void check(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

