/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.categoryref.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.categoryref.command.AppointCommand;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryref.service.CompanyCategoryRefService;
import com.els.base.common.BillInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u6240\u5c5e\u7ec4\u7684\u5173\u7cfb")
@Controller
@RequestMapping(value={"companyCategoryRef"})
public class CompanyCategoryRefController {
    @Resource
    protected CompanyCategoryRefService companyCategoryRefService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod="POST", value="\u7ed9\u4f9b\u5e94\u5546\u5206\u7ec4")
    @RequestMapping(value={"service/appoint"})
    @ResponseBody
    public ResponseResult<String> appoint(@ApiParam(value="\u4f9b\u5e94\u5546\u5206\u7ec4ID") @RequestParam(required=true) String companyCategoryNo, @ApiParam(value="\u4f9b\u5e94\u5546\u5217\u8868") @RequestBody List<Company> companyList) {
        AppointCommand cmd = new AppointCommand(companyCategoryNo, companyList);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u6240\u5c5e\u7ec4\u7684\u5173\u7cfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyCategoryRef", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyCategoryRef>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyCategoryRefExample example = new CompanyCategoryRefExample();
        example.setPageView((PageView<CompanyCategoryRef>)new PageView(pageNo, pageSize));
        CompanyCategoryRefExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyCategoryRefService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u67e5\u8be2\u5168\u90e8\u4f9b\u5e94\u5546\u6240\u5c5e\u7ec4\u7684\u5173\u7cfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyCategoryRef", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<CompanyCategoryRef>> findAll(@RequestBody(required=false) QueryParamWapper wapper) {
        CompanyCategoryRefExample example = new CompanyCategoryRefExample();
        CompanyCategoryRefExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List companyCategoryRefs = this.companyCategoryRefService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)companyCategoryRefs);
    }
}

