/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.categoryref.service.impl;

import com.els.base.categoryref.dao.CompanyCategoryRefMapper;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryref.service.CompanyCategoryRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyCategoryRefService")
public class CompanyCategoryRefServiceImpl
implements CompanyCategoryRefService {
    @Resource
    protected CompanyCategoryRefMapper companyCategoryRefMapper;

    @Override
    @Cacheable(value={"companyCategoryRef"}, keyGenerator="redisKeyGenerator")
    public int countByExample(CompanyCategoryRefExample example) {
        return this.companyCategoryRefMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"companyCategoryRef"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(CompanyCategoryRef record, CompanyCategoryRefExample example) {
        return this.companyCategoryRefMapper.updateByExampleSelective(record, example);
    }

    @Override
    @CacheEvict(value={"companyCategoryRef"}, allEntries=true)
    @Transactional
    public void deleteByExample(CompanyCategoryRefExample example) {
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u4e0d\u80fd\u8fdb\u884c\u5168\u8868\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.companyCategoryRefMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"companyCategoryRef"}, allEntries=true)
    @Transactional
    public void deleteByCompanyCategoryNo(List<String> companyCategoryNos) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCategoryNoIn((List)companyCategoryNos);
        CompanyCategoryRef companyCategoryRef = new CompanyCategoryRef();
        companyCategoryRef.setIsEnable(Constant.NO_INT);
        int i = this.companyCategoryRefMapper.countByExample(companyCategoryRefExample);
        if (i > 0) {
            this.companyCategoryRefMapper.updateByExampleSelective(companyCategoryRef, companyCategoryRefExample);
        }
    }

    @Override
    @CacheEvict(value={"companyCategoryRef"}, allEntries=true)
    @Transactional
    public void deleteByCompanyCategoryNo(String companyCategoryNo) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCategoryNoEqualTo(companyCategoryNo);
        CompanyCategoryRef companyCategoryRef = new CompanyCategoryRef();
        companyCategoryRef.setIsEnable(Constant.NO_INT);
        int i = this.companyCategoryRefMapper.countByExample(companyCategoryRefExample);
        if (i > 0) {
            this.companyCategoryRefMapper.updateByExampleSelective(companyCategoryRef, companyCategoryRefExample);
        }
    }

    @Override
    @Cacheable(value={"companyCategoryRef"}, keyGenerator="redisKeyGenerator")
    public List<CompanyCategoryRef> findByCompanyCategoryNo(String companyCategoryNo) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCategoryNoEqualTo(companyCategoryNo);
        List<CompanyCategoryRef> companyCategoryRefList = this.companyCategoryRefMapper.selectByExample(companyCategoryRefExample);
        return companyCategoryRefList;
    }

    @CacheEvict(value={"companyCategoryRef"}, allEntries=true)
    public void addObj(CompanyCategoryRef t) {
        this.companyCategoryRefMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyCategoryRef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyCategoryRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyCategoryRef"}, allEntries=true)
    public void modifyObj(CompanyCategoryRef t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyCategoryRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyCategoryRef"}, keyGenerator="redisKeyGenerator")
    public CompanyCategoryRef queryObjById(String id) {
        return this.companyCategoryRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyCategoryRef"}, keyGenerator="redisKeyGenerator")
    public List<CompanyCategoryRef> queryAllObjByExample(CompanyCategoryRefExample example) {
        return this.companyCategoryRefMapper.selectByExample(example);
    }

    @Cacheable(value={"companyCategoryRef"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyCategoryRef> queryObjByPage(CompanyCategoryRefExample example) {
        PageView<CompanyCategoryRef> pageView = example.getPageView();
        pageView.setQueryResult(this.companyCategoryRefMapper.selectByExampleByPage(example));
        return pageView;
    }
}

