/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.categoryswitch.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;

public class UpdateCommand
extends AbstractBillCommand<String> {
    private CategoryBillSwitch categoryBillSwitch;

    public UpdateCommand(CategoryBillSwitch categoryBillSwitch) {
        this.categoryBillSwitch = categoryBillSwitch;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(this.categoryBillSwitch);
        this.process(this.categoryBillSwitch);
        return null;
    }

    private void process(CategoryBillSwitch categoryBillSwitch) {
        CategoryBillSwitch categoryBillSwitch1 = this.updateCategoryBillSwitch(categoryBillSwitch);
        this.updateBillSwitch(categoryBillSwitch1);
    }

    private void updateBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        this.deleteBillSwitch(categoryBillSwitch);
        this.addBillSwitch(categoryBillSwitch);
    }

    private void addBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andCategoryNoEqualTo(categoryBillSwitch.getCategoryNo());
        List companyCategoryRefList = this.billInvorker.getCompanyCategoryRefService().queryAllObjByExample((IExample)companyCategoryRefExample);
        Assert.isNotEmpty((Collection)companyCategoryRefList, (String)("\u8bf7\u4e3a\u5206\u7ec4\u7f16\u7801\u4e3a\uff1a" + categoryBillSwitch.getCategoryNo() + ",\u5206\u7ec4\u540d\u5b57\u4e3a\uff1a" + categoryBillSwitch.getCategoryName() + ",\u5206\u914d\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\uff01"));
        ArrayList<BillSwitch> list = new ArrayList<BillSwitch>();
        for (CompanyCategoryRef companyCategoryRef : companyCategoryRefList) {
            BillSwitch billSwitch = this.initBillSwitch(categoryBillSwitch, companyCategoryRef);
            list.add(billSwitch);
        }
        this.billInvorker.getBillSwitchService().addAll(list);
    }

    private BillSwitch initBillSwitch(CategoryBillSwitch categoryBillSwitch, CompanyCategoryRef companyCategoryRef) {
        BillSwitch billSwitch = new BillSwitch();
        billSwitch.setId(UUIDGenerator.generateUUID());
        billSwitch.setIsEnable(Constant.YES_INT);
        billSwitch.setProjectId(categoryBillSwitch.getProjectId());
        billSwitch.setCreateTime(new Date());
        billSwitch.setUpdateTime(new Date());
        billSwitch.setSwitchFlag(categoryBillSwitch.getSwitchFlag());
        billSwitch.setStartTime(categoryBillSwitch.getStartTime());
        billSwitch.setEndTime(categoryBillSwitch.getEndTime());
        billSwitch.setPurCompanyId(categoryBillSwitch.getPurCompanyId());
        billSwitch.setPurCompanyFullName(categoryBillSwitch.getPurCompanyFullName());
        billSwitch.setPurCompanyName(categoryBillSwitch.getPurCompanyName());
        billSwitch.setPurCompanySapCode(categoryBillSwitch.getPurCompanySapCode());
        billSwitch.setPurCompanySrmCode(categoryBillSwitch.getPurCompanySrmCode());
        billSwitch.setPurUserId(categoryBillSwitch.getPurUserId());
        billSwitch.setPurUserName(categoryBillSwitch.getPurUserName());
        billSwitch.setSupCompanyId(companyCategoryRef.getSupCompanyId());
        billSwitch.setSupCompanyFullName(companyCategoryRef.getSupCompanyFullName());
        billSwitch.setSupCompanyName(companyCategoryRef.getSupCompanyName());
        billSwitch.setSupCompanySapCode(companyCategoryRef.getSupCompanySapCode());
        billSwitch.setSupCompanySrmCode(companyCategoryRef.getSupCompanySrmCode());
        billSwitch.setCategoryNo(categoryBillSwitch.getCategoryNo());
        billSwitch.setCategoryName(categoryBillSwitch.getCategoryName());
        billSwitch.setVoucherStartTime(categoryBillSwitch.getVoucherStartTime());
        billSwitch.setVoucherEndTime(categoryBillSwitch.getVoucherEndTime());
        return billSwitch;
    }

    private void deleteBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andCategoryNoEqualTo(categoryBillSwitch.getCategoryNo());
        this.billInvorker.getBillSwitchService().deleteByExample(billSwitchExample);
    }

    private CategoryBillSwitch updateCategoryBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        CategoryBillSwitch oldCategoryBillSwitch = (CategoryBillSwitch)this.billInvorker.getCategoryBillSwitchService().queryObjById(categoryBillSwitch.getId());
        Assert.isNotNull((Object)oldCategoryBillSwitch, (String)"\u5f00\u7968\u9650\u5236\u4e0d\u5b58\u5728");
        oldCategoryBillSwitch.setSwitchFlag(categoryBillSwitch.getSwitchFlag());
        this.initVoucher(categoryBillSwitch);
        oldCategoryBillSwitch.setStartTime(categoryBillSwitch.getStartTime());
        oldCategoryBillSwitch.setEndTime(categoryBillSwitch.getEndTime());
        oldCategoryBillSwitch.setVoucherStartTime(categoryBillSwitch.getVoucherStartTime());
        oldCategoryBillSwitch.setVoucherEndTime(categoryBillSwitch.getVoucherEndTime());
        oldCategoryBillSwitch.setUpdateTime(new Date());
        this.billInvorker.getCategoryBillSwitchService().updateByPrimaryKey(oldCategoryBillSwitch);
        return oldCategoryBillSwitch;
    }

    private void initVoucher(CategoryBillSwitch categoryBillSwitch) {
        if (categoryBillSwitch.getVoucherStartTime() != null) {
            Date start = DateUtils.truncate((Date)categoryBillSwitch.getVoucherStartTime(), (int)5);
            categoryBillSwitch.setVoucherStartTime(start);
        }
        if (categoryBillSwitch.getVoucherEndTime() != null) {
            Date end = DateUtils.truncate((Date)categoryBillSwitch.getVoucherEndTime(), (int)5);
            categoryBillSwitch.setVoucherEndTime(end);
        }
    }

    private void check(CategoryBillSwitch categoryBillSwitch) {
        Assert.isNotNull((Object)categoryBillSwitch, (String)"\u5bf9\u8d26\u9650\u5236\u8bbe\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)categoryBillSwitch.getId(), (String)"\u5bf9\u8d26\u9650\u5236\u8bbe\u7f6e\u4fe1\u606fID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)categoryBillSwitch.getStartTime(), (String)"\u5bf9\u8d26\u5f00\u59cb\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)categoryBillSwitch.getEndTime(), (String)"\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (categoryBillSwitch.getVoucherStartTime() != null) {
            Assert.isNotNull((Object)categoryBillSwitch.getVoucherEndTime(), (String)"\u51ed\u8bc1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (categoryBillSwitch.getVoucherEndTime() != null) {
            Assert.isNotNull((Object)categoryBillSwitch.getVoucherStartTime(), (String)"\u51ed\u8bc1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

