/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.invoice.command;

import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditCommand
extends AbstractBillCommand<BillInvoice> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private BillInvoice billInvoice;

    public EditCommand() {
    }

    public EditCommand(BillInvoice billInvoice) {
        this.billInvoice = billInvoice;
    }

    @Override
    public BillInvoice execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validate(this.billInvoice);
        this.processor(this.billInvoice);
        return null;
    }

    private void processor(BillInvoice billInvoice) {
        BillInvoice old = (BillInvoice)this.billInvorker.getBillInvoiceService().queryObjById(billInvoice.getId());
        old.setId(old.getId());
        old.setInvoiceNo(billInvoice.getInvoiceNo());
        old.setInvoiceTime(billInvoice.getInvoiceTime());
        old.setInvoiceDistribution(billInvoice.getInvoiceDistribution());
        old.setInvoiceText(billInvoice.getInvoiceText());
        old.setInvoiceTitle(billInvoice.getInvoiceTitle());
        this.billInvorker.getBillInvoiceService().modifyObj(old);
    }

    private void validate(BillInvoice billInvoice) {
        Assert.isNotNull((Object)billInvoice, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getId(), (String)"\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billInvoice.getBillId(), (String)"\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getInvoiceNo(), (String)"\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billInvoice.getInvoiceTime(), (String)"\u53d1\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        int length = StringUtils.trim((String)billInvoice.getInvoiceNo()).length();
        if (length > 18) {
            throw new CommonException("\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc718\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andInvoiceNoEqualTo(billInvoice.getInvoiceNo()).andInvoiceFlagEqualTo(Constant.YES_INT).andIdNotEqualTo(billInvoice.getId());
        int i = this.billInvorker.getBillInvoiceService().countByExample(billInvoiceExample);
        if (i > 0) {
            throw new CommonException("\u53d1\u7968\u53f7\u5df2\u7ecf\u5b58\u5728\u4e86\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

