/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.payment.controller;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.BillInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.payment.command.ImportCommand;
import com.els.base.payment.entity.BillPayment;
import com.els.base.payment.entity.BillPaymentExample;
import com.els.base.payment.service.BillPaymentService;
import com.els.base.payment.vo.BillPaymentVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4ed8\u6b3e\u660e\u7ec6")
@Controller
@RequestMapping(value={"billPayment"})
public class BillPaymentController {
    @Resource
    protected BillPaymentService billPaymentService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod="GET", value="\u4eceSAP\u5bfc\u5165\u4ed8\u6b3e\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", required=true, value="\u4ed8\u6b3e\u7c7b\u578b", paramType="query", dataType="String", defaultValue="1"), @ApiImplicitParam(name="startYear", required=true, value="\u4f1a\u8ba1\u5e74\u5ea6\u5f00\u59cb\u65f6\u95f4", paramType="query", dataType="int", defaultValue="2011"), @ApiImplicitParam(name="endYear", required=true, value="\u4f1a\u8ba1\u5e74\u5ea6\u7ed3\u675f\u65f6\u95f4", paramType="query", dataType="int", defaultValue="2018"), @ApiImplicitParam(name="paymentStartTime", required=false, value="\u51ed\u8bc1\u5f00\u59cb\u65f6\u95f4"), @ApiImplicitParam(name="paymentEndTime", required=true, value="\u51ed\u8bc1\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4"), @ApiImplicitParam(name="companySapCode", required=true, value="\u4f9b\u5e94\u5546sap\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/importBillPaymentFromSap"})
    @ResponseBody
    public ResponseResult<String> importBillPaymentFromSap(@RequestParam(required=true, defaultValue="1") String type, @RequestParam(required=true, defaultValue="2011") int startYear, @RequestParam(required=true, defaultValue="2018") int endYear, @RequestParam(required=false) Date paymentStartTime, @RequestParam(required=false) Date paymentEndTime, @RequestParam(required=true) String companySapCode) {
        BillPaymentVo billPaymentVo = new BillPaymentVo();
        billPaymentVo.setCompanySapCode(companySapCode);
        billPaymentVo.setEndYear(endYear);
        billPaymentVo.setStartYear(startYear);
        billPaymentVo.setPaymentStartTime(paymentStartTime);
        billPaymentVo.setPaymentEndTime(paymentEndTime);
        billPaymentVo.setType(type);
        ImportCommand cmd = new ImportCommand(billPaymentVo);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u4eceSAP\u5bfc\u5165\u4ed8\u6b3e\u660e\u7ec6")
    @RequestMapping(value={"service/sap/import"})
    @ResponseBody
    public ResponseResult<String> sapImport(@RequestBody(required=true) BillPaymentVo billPayment) {
        ImportCommand cmd = new ImportCommand(billPayment);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4ed8\u6b3e\u660e\u7ec6-\u4f9b\u5e94\u65b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillPayment", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillPayment>> findForSupByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillPaymentExample example = new BillPaymentExample();
        example.setPageView((PageView<BillPayment>)new PageView(pageNo, pageSize));
        BillPaymentExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        criteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billPaymentService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4ed8\u6b3e\u660e\u7ec6-\u91c7\u8d2d\u65b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillPayment", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillPayment>> findForPurByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        if (!CollectionUtils.isEmpty((Collection)companyList)) {
            ArrayList<String> sapCompanyList = new ArrayList<String>();
            for (Company c : companyList) {
                Assert.isNotBlank((String)c.getCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                sapCompanyList.add(c.getCompanySapCode());
            }
            BillPaymentExample example = new BillPaymentExample();
            example.setPageView((PageView<BillPayment>)new PageView(pageNo, pageSize));
            BillPaymentExample.Criteria criteria = example.createCriteria();
            criteria.andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());
            criteria.andSupCompanySapCodeIn(sapCompanyList);
            if (wapper != null) {
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
            }
            PageView pageData = this.billPaymentService.queryObjByPage((IExample)example);
            return ResponseResult.success((Object)pageData);
        }
        PageView pageData = new PageView();
        pageData.setQueryResult(new ArrayList());
        return ResponseResult.success((Object)pageData);
    }
}

