/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.voucher.command;

import com.els.base.bill.command.CreateBillFilterCommand;
import com.els.base.bill.command.PostTimeFilterCommand;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.AbstractResultVO;
import com.els.base.utils.SpringContextHolder;
import com.els.base.voucher.service.BillVoucherImportFromSapService;
import com.els.base.voucher.vo.ImportVoucherVo;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapImportCommand
extends AbstractBillCommand<AbstractResultVO> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private ImportVoucherVo importVoucherVo;

    public SapImportCommand(ImportVoucherVo importVoucherVo) {
        this.importVoucherVo = importVoucherVo;
    }

    @Override
    public AbstractResultVO execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        String supCompanySapCode = this.importVoucherVo.getSupCompanySapCode();
        Date startTime = this.importVoucherVo.getStartTime();
        Date endTime = this.importVoucherVo.getEndTime();
        Assert.isNotBlank((String)supCompanySapCode, (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)startTime, (String)"\u51ed\u8bc1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)endTime, (String)"\u51ed\u8bc1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u4f9b\u5e94\u5546SAP\u7f16\u7801:{}", (Object)supCompanySapCode);
        this.logger.info("\u51ed\u8bc1\u5f00\u59cb\u65f6\u95f4:{}", (Object)startTime);
        this.logger.info("\u51ed\u8bc1\u7ed3\u675f\u65f6\u95f4:{}", (Object)endTime);
        CreateBillFilterCommand cmd = new CreateBillFilterCommand(supCompanySapCode);
        this.billInvorker.invoke(cmd);
        PostTimeFilterCommand cmd2 = new PostTimeFilterCommand(supCompanySapCode, startTime, endTime);
        this.billInvorker.invoke(cmd2);
        Date startTime1 = DateUtils.truncate((Date)startTime, (int)5);
        Date endTime1 = DateUtils.truncate((Date)endTime, (int)5);
        String startTimeStr = DateFormatUtils.format((Date)startTime1, (String)"yyyy-MM-dd");
        String endTimeStr = DateFormatUtils.format((Date)endTime1, (String)"yyyy-MM-dd");
        if (startTime1.getTime() > endTime1.getTime()) {
            throw new CommonException("\u51ed\u8bc1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u51ed\u8bc1\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        AbstractResultVO abstractResultVO = ((BillVoucherImportFromSapService)SpringContextHolder.getOneBean(BillVoucherImportFromSapService.class)).importByVoucherDate(supCompanySapCode, startTimeStr, endTimeStr);
        return abstractResultVO;
    }
}

