/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.voucher.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.BillInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.voucher.command.DeleteCommand;
import com.els.base.voucher.command.PurExportExcelCommand;
import com.els.base.voucher.command.SapImportCommand;
import com.els.base.voucher.command.SupExportExcelCommand;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.els.base.voucher.utils.ForBillIntegerConverter;
import com.els.base.voucher.vo.ImportVoucherVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u5165\u9000\u5e93\u51ed\u8bc1,\u6298\u8ba9\u5355")
@Controller
@RequestMapping(value={"billVoucher"})
public class BillVoucherController {
    Logger logger = LoggerFactory.getLogger(BillVoucher.class);
    @Resource
    private BillVoucherService billVoucherService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(value="\u4f9b\u5e94\u5546\u5bfc\u51fa\u5165\u9000\u5e93\u51ed\u8bc1\u6570\u636e", httpMethod="POST")
    @RequestMapping(value={"service/sup/exportBillVoucher"})
    @ResponseBody
    public ResponseResult<FileData> exportBillVoucherForSup(@RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        SupExportExcelCommand cmd = new SupExportExcelCommand(wapper);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        FileData fileData = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5546\u5bfc\u51fa\u5165\u9000\u5e93\u4ee5\u53ca\u6298\u8ba9\u5355\u6570\u636e", httpMethod="POST")
    @RequestMapping(value={"service/pur/exportBillVoucher"})
    @ResponseBody
    public ResponseResult<FileData> exportBillVoucherForPur(@RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        PurExportExcelCommand cmd = new PurExportExcelCommand(wapper);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        FileData fileData = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="GET", value="\u91c7\u8d2d\u65b9\u548c\u4f9b\u5e94\u65b9\u4ecesap\u540c\u6b65\u53ef\u5f00\u7968\u6e05\u5355\u6570\u636e\u5230srm")
    @RequestMapping(value={"service/importVoucherFromSap"})
    @ResponseBody
    public ResponseResult<String> importVoucherFromSap(@RequestParam(required=true) String supCompanySapCode, @RequestParam(required=true) Date startTime, @RequestParam(required=true) Date endTime) {
        ImportVoucherVo importVoucherVo = new ImportVoucherVo();
        importVoucherVo.setSupCompanySapCode(supCompanySapCode);
        importVoucherVo.setStartTime(startTime);
        importVoucherVo.setEndTime(endTime);
        SapImportCommand cmd = new SapImportCommand(importVoucherVo);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u548c\u4f9b\u5e94\u65b9\u4ecesap\u540c\u6b65\u53ef\u5f00\u7968\u6e05\u5355\u6570\u636e\u5230srm")
    @RequestMapping(value={"service/importVoucherFromSap2"})
    @ResponseBody
    public ResponseResult<String> importVoucherFromSap(@RequestBody(required=true) ImportVoucherVo importVoucherVo) {
        SapImportCommand cmd = new SapImportCommand(importVoucherVo);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u53ef\u5f00\u7968\u6e05\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        DeleteCommand cmd = new DeleteCommand(ids);
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u65b9--\u5206\u9875\u67e5\u8be2\u53ef\u5f00\u7968\u6e05\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillVoucher", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        Company company = CompanyUtils.currentCompany();
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9--\u5206\u9875\u67e5\u8be2\u53ef\u5f00\u7968\u6e05\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillVoucher", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        Company company = CompanyUtils.currentCompany();
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="1\u3001\u65b0\u589e\u5f00\u7968\u65f6\u5019,\u6839\u636e\u4f9b\u5e94\u5546sap\u7f16\u7801\u548c\u51ed\u8bc1\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u62c9\u53d6\u672a\u5bf9\u8d26\u7684sap\u5bf9\u8d26\u660e\u7ec6\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillVoucher", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/voucher/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andBillTypeIsNotNull();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="1.1\u3001\u65b0\u589e\u5f00\u7968\u65f6\u5019,\u6839\u636e\u4f9b\u5e94\u5546sap\u7f16\u7801\u548c\u51ed\u8bc1\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u62c9\u53d6\u672a\u5bf9\u8d26\u7684\u6298\u8ba9\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillVoucher", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/rebate/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findRebateByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andBillTypeIsNotNull().andIsRebateEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="2\u3001\u65b0\u589e\u5f00\u7968\u6e05\u5355\uff0c\u53d6\u6d88sap\u5165\u9000\u5e93\u660e\u7ec6\u7684\u65f6\u5019\uff0c\u8fd4\u56de\u6ca1\u53d6\u6d88sap\u5165\u9000\u5e93\u660e\u7ec6\u5bf9\u5e94\u7684\u6298\u8ba9\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postingStartTime", required=false), @ApiImplicitParam(name="postingEndTime", required=false), @ApiImplicitParam(name="supCompanySapCode", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/rebate/reverse/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findReverseRebateByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=true) Date postingStartTime, @RequestParam(required=true) Date postingEndTime, @RequestParam(required=true) String supCompanySapCode, @RequestBody(required=false) List<BillVoucher> billVoucherList) {
        this.logger.info("\u4f9b\u5e94\u5546SAP\u7f16\u7801:{}", (Object)supCompanySapCode);
        this.logger.info("\u5165\u9000\u5e93\u51ed\u8bc1\u5f00\u59cb\u65f6\u95f4:{}", (Object)postingStartTime);
        this.logger.info("\u5165\u9000\u5e93\u51ed\u8bc1\u7ed3\u675f\u65f6\u95f4:{}", (Object)postingEndTime);
        Date postingStartTime2 = DateUtils.truncate((Date)postingStartTime, (int)5);
        Date postingEndTime2 = DateUtils.truncate((Date)postingEndTime, (int)5);
        if (CollectionUtils.isNotEmpty(billVoucherList)) {
            List ids = billVoucherList.stream().map(BillVoucher::getId).collect(Collectors.toList());
            BillVoucherExample example = new BillVoucherExample();
            example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
            example.setOrderByClause("CREATE_TIME DESC");
            BillVoucherExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andSupCompanySapCodeEqualTo(supCompanySapCode).andPostingTimeBetween(postingStartTime2, postingEndTime2).andBillTypeIsNotNull().andIsRebateEqualTo(Constant.YES_INT).andIdNotIn(ids);
            PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
            return ResponseResult.success((Object)pageData);
        }
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andSupCompanySapCodeEqualTo(supCompanySapCode).andPostingTimeBetween(postingStartTime2, postingEndTime2).andBillTypeIsNotNull().andIsRebateEqualTo(Constant.YES_INT);
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="3\u3001\u65b0\u589e\u5f00\u7968\u6e05\u5355\uff0c\u9009\u4e2dsap\u5165\u9000\u5e93\u660e\u7ec6\u7684\u65f6\u5019\uff0c\u67e5\u770b\u76f8\u5e94\u7684\u6298\u8ba9\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postingStartTime", required=false), @ApiImplicitParam(name="postingEndTime", required=false), @ApiImplicitParam(name="supCompanySapCode", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/rebate/positive/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findPositiveRebateByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=true) Date postingStartTime, @RequestParam(required=true) Date postingEndTime, @RequestParam(required=true) String supCompanySapCode, @RequestBody(required=false) List<BillVoucher> billVoucherList) {
        Assert.isNotBlank((String)supCompanySapCode, (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)postingStartTime, (String)"\u8fc7\u8d26\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)postingEndTime, (String)"\u8fc7\u8d26\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank((String)billVoucher.getId(), (String)"\u51ed\u8bc1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.logger.info("\u4f9b\u5e94\u5546SAP\u7f16\u7801:{}", (Object)supCompanySapCode);
        this.logger.info("\u5165\u9000\u5e93\u51ed\u8bc1\u5f00\u59cb\u65f6\u95f4:{}", (Object)postingStartTime);
        this.logger.info("\u5165\u9000\u5e93\u51ed\u8bc1\u7ed3\u675f\u65f6\u95f4:{}", (Object)postingEndTime);
        Date postingStartTime2 = DateUtils.truncate((Date)postingStartTime, (int)5);
        Date postingEndTime2 = DateUtils.truncate((Date)postingEndTime, (int)5);
        if (CollectionUtils.isNotEmpty(billVoucherList)) {
            List ids = billVoucherList.stream().map(BillVoucher::getId).collect(Collectors.toList());
            BillVoucherExample example = new BillVoucherExample();
            example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
            example.setOrderByClause("CREATE_TIME DESC");
            BillVoucherExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andSupCompanySapCodeEqualTo(supCompanySapCode).andPostingTimeBetween(postingStartTime2, postingEndTime2).andBillTypeIsNotNull().andIsRebateEqualTo(Constant.YES_INT).andIdIn(ids);
            PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
            return ResponseResult.success((Object)pageData);
        }
        PageView pageData = new PageView();
        pageData.setQueryResult(new ArrayList());
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u65b0\u5efa\u5f00\u7968\u6e05\u5355\uff0c\u5bfc\u51fa\u672a\u5bf9\u8d26\u660e\u7ec6")
    @RequestMapping(value={"service/exportSapBillDetail"})
    @ResponseBody
    public ModelAndView exportSapBillDetail(@RequestParam(required=true) String supCompanySapCode, @RequestParam(required=true) Date startTime, @RequestParam(required=true) Date endTime, HttpServletResponse response) throws Exception {
        Assert.isNotBlank((String)supCompanySapCode, (String)"\u4f9b\u5e94\u5546\u7684SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)startTime, (String)"\u51ed\u8bc1\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)endTime, (String)"\u51ed\u8bc1\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillVoucherExample example = new BillVoucherExample();
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andSupCompanySapCodeEqualTo(supCompanySapCode).andPostingTimeBetween(startTime, endTime);
        List billVouchers = this.billVoucherService.queryAllObjByExample((IExample)example);
        List<TitleAndModelKey> titleAndModelKeys = this.createExportExcelHeader();
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode("SAP\u5bf9\u8d26\u660e\u7ec6.xls", "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream outputStream = response.getOutputStream();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)billVouchers, (String)"SAP\u5bf9\u8d26\u660e\u7ec6", null, (int)0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return null;
    }

    private List<TitleAndModelKey> createExportExcelHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7b80\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u516c\u53f8SAP\u7f16\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"purchaseOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u884c\u9879", (String)"purchaseOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8fc7\u8d26\u65e5\u671f", (String)"postingTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u51ed\u8bc1\u53f7", (String)"materialVoucherNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u51ed\u8bc1\u884c\u53f7", (String)"materialVoucherItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5355\u4f4d", (String)"materialUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u6570\u91cf", (String)"materialQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6700\u65b0\u91c7\u8d2d\u4fe1\u606f\u8bb0\u5f55\u4ef7\u683c", (String)"latestPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4ef7", (String)"orderPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u79cd", (String)"currencyType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7801", (String)"taxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387", (String)"taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee\u7c7b\u522b", (String)"projectTypes"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u79fb\u52a8\u7c7b\u578b", (String)"billType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u79fb\u52a8\u7c7b\u578b\u7b26\u53f7", (String)"billTypeSign"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u91d1\u989d", (String)"orderAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u672a\u7a0e\u91d1\u989d", (String)"notIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u7a0e\u989d", (String)"taxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d", (String)"includeTaxAmount"));
        ForBillIntegerConverter isRebateConverter = new ForBillIntegerConverter();
        TitleAndModelKey isRebate = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u6298\u8ba9", (String)"isRebate");
        isRebate.setToStrConverter((ObjToStrConverter)isRebateConverter);
        titleAndModelKeys.add(isRebate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6298\u8ba9\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"rebateNotIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6298\u8ba9\u542b\u7a0e\u91d1\u989d", (String)"rebateIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6298\u8ba9\u7a0e\u989d", (String)"rebateTaxAmount"));
        return titleAndModelKeys;
    }
}

