/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.voucher.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.voucher.dao.BillVoucherMapper;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillVoucherService")
public class BillVoucherServiceImpl
implements BillVoucherService {
    @Resource
    protected BillVoucherMapper billVoucherMapper;

    @Override
    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void switchBillVoucherFlag(List<BillVoucher> billVoucherList, Integer billFlag) {
        Assert.isNotEmpty(billVoucherList, (String)"\u51ed\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank((String)billVoucher.getId(), (String)"\u51ed\u8bc1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<String> ids = billVoucherList.stream().map(BillVoucher::getId).collect(Collectors.toList());
        this.switchBillVoucherFlagById(ids, billFlag);
    }

    @Override
    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void switchBillVoucherFlagById(List<String> ids, Integer billFlag) {
        Assert.isNotEmpty(ids, (String)"\u51ed\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billFlag);
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria().andIdIn((List)ids);
        BillVoucher billVoucher = new BillVoucher();
        billVoucher.setBillFlag(billFlag);
        int i = this.billVoucherMapper.countByExample(billVoucherExample);
        if (i > 0) {
            this.billVoucherMapper.updateByExampleSelective(billVoucher, billVoucherExample);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void addAll(List<BillVoucher> list) {
        Assert.isNotEmpty(list, (String)"\u4fdd\u5b58\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (BillVoucher billVoucher : list) {
            billVoucher.setId(UUIDGenerator.generateUUID());
        }
        List group = Lists.partition(list, (int)10);
        for (List billVouchers : group) {
            this.billVoucherMapper.insertBatch(billVouchers);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void deleteByExample(BillVoucherExample example) {
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u4e0d\u80fd\u8fdb\u884c\u5168\u8868\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.billVoucherMapper.deleteByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public int insertBatch(List<BillVoucher> list) {
        Assert.isNotEmpty(list, (String)"\u5bf9\u8d26\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.billVoucherMapper.insertBatch(list);
    }

    @Override
    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    @Transactional
    public int countByExample(BillVoucherExample example) {
        return this.billVoucherMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(BillVoucher record, BillVoucherExample example) {
        return this.billVoucherMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void addObj(BillVoucher t) {
        this.billVoucherMapper.insertSelective(t);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billVoucherMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void modifyObj(BillVoucher t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billVoucherMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    public BillVoucher queryObjById(String id) {
        return this.billVoucherMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    public List<BillVoucher> queryAllObjByExample(BillVoucherExample example) {
        return this.billVoucherMapper.selectByExample(example);
    }

    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    public PageView<BillVoucher> queryObjByPage(BillVoucherExample example) {
        PageView<BillVoucher> pageView = example.getPageView();
        pageView.setQueryResult(this.billVoucherMapper.selectByExampleByPage(example));
        return pageView;
    }
}

