/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBillFilterCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private String supCompanySapCode;

    public CreateBillFilterCommand(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(this.supCompanySapCode);
        this.process();
        return null;
    }

    private void check(String supCompanySapCode) {
        Assert.isNotBlank((String)supCompanySapCode, (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    private void process() {
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(this.supCompanySapCode);
        List billSwitches = this.billInvorker.getBillSwitchService().queryAllObjByExample((IExample)billSwitchExample);
        if (CollectionUtils.isEmpty((Collection)billSwitches)) {
            return;
        }
        for (BillSwitch billSwitch : billSwitches) {
            Assert.isNotNull((Object)billSwitch);
            Integer switchFlag = billSwitch.getSwitchFlag();
            Assert.isNotNull((Object)switchFlag, (String)"\u5f00\u8d26\u65f6\u95f4\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if (switchFlag.equals(Constant.NO_INT)) continue;
            Integer startTime = billSwitch.getStartTime();
            Integer endTime = billSwitch.getEndTime();
            Assert.isNotNull((Object)startTime, (String)"\u5f00\u7968\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotNull((Object)endTime, (String)"\u5f00\u7968\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.logger.info("\u91c7\u8d2d\u5458\u8bbe\u7f6e\u7684\u5f00\u7968\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a{}", (Object)startTime);
            this.logger.info("\u91c7\u8d2d\u5458\u8bbe\u7f6e\u7684\u5f00\u7968\u7ed3\u675f\u65f6\u95f4\u4e3a\uff1a{}", (Object)endTime);
            Calendar calendar = Calendar.getInstance();
            int date = calendar.get(5);
            this.logger.info("\u7cfb\u7edf\u5f53\u524d\u5929\u6570\u4e3a\uff1a{}", (Object)date);
            if (date >= startTime && date <= endTime) continue;
            throw new CommonException("\u4e0d\u5728\u5bf9\u8d26\u65f6\u95f4\u5185,\u8bf7\u8054\u7cfb\u91c7\u8d2d\u5458\u8bbe\u7f6e\u5bf9\u8d26\u65f6\u95f4\uff0c\u8c22\u8c22\uff01");
        }
    }
}

