/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.bill.entity.BillItemReport;
import com.els.base.bill.entity.BillItemReportExample;
import com.els.base.bill.vo.BillItemReportExportExcelVo;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;

public class ExportReportCommand
extends AbstractBillCommand<FileData> {
    QueryParamWapper wapper;

    public ExportReportCommand() {
    }

    public ExportReportCommand(QueryParamWapper wapper) {
        this.wapper = wapper;
    }

    @Override
    public FileData execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validData(this.wapper);
        return this.processor(this.wapper);
    }

    private FileData processor(QueryParamWapper wapper) {
        BillItemReportExample example = new BillItemReportExample();
        BillItemReportExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(this.getProject().getId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List<BillItemReport> billList = this.billInvorker.getBillItemService().queryBillItemReportForExcel(example);
        FileData fileData = new FileData();
        try {
            fileData = this.getFileData(billList);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff01");
        }
        return fileData;
    }

    private FileData getFileData(List<BillItemReport> billItemReportList) throws IOException {
        FileData fileData = new FileData();
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        fileData.setProjectId(this.getProject().getId());
        fileData.setCompanyId(CompanyUtils.currentCompanyId());
        fileData.setFileName(MessageFormat.format("\u5f00\u7968\u6e05\u5355\u884c-{0}", dateStr) + ".xls");
        fileData.setFileSuffix("xls");
        fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
        fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
        FileOutputStream fos = new FileOutputStream(fileData.toFile());
        if (CollectionUtils.isEmpty(billItemReportList)) {
            return fileData;
        }
        ArrayList<BillItemReportExportExcelVo> billItemReportExportExcelVos = new ArrayList<BillItemReportExportExcelVo>();
        for (BillItemReport billItem : billItemReportList) {
            BillItemReportExportExcelVo billItemExportExcelVo = new BillItemReportExportExcelVo();
            BeanUtils.copyProperties((Object)billItem, (Object)billItemExportExcelVo);
            billItemReportExportExcelVos.add(billItemExportExcelVo);
        }
        ExportParams params = new ExportParams();
        params.setSheetName("\u5f00\u7968\u6e05\u5355\u884c");
        params.setType(ExcelType.HSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, BillItemReportExportExcelVo.class, billItemReportExportExcelVos);
        workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
        return fileData;
    }

    private void validData(QueryParamWapper wapper) {
    }
}

