/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostTimeFilterCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private String supCompanySapCode;
    private Date postingStartTime;
    private Date postingEndTime;

    public PostTimeFilterCommand(String supCompanySapCode, Date postingStartTime, Date postingEndTime) {
        this.supCompanySapCode = supCompanySapCode;
        this.postingStartTime = postingStartTime;
        this.postingEndTime = postingEndTime;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validData(this.supCompanySapCode, this.postingStartTime, this.postingEndTime);
        return null;
    }

    private void validData(String supCompanySapCode, Date postingStartTime, Date postingEndTime) {
        Assert.isNotBlank((String)supCompanySapCode, (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)postingStartTime, (String)"\u51ed\u8bc1\u5f00\u59cb\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)postingEndTime, (String)"\u51ed\u8bc1\u7ed3\u675f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (postingStartTime.getTime() > postingEndTime.getTime()) {
            throw new CommonException("\u51ed\u8bc1\u5f00\u59cb\u65e5\u4e0d\u80fd\u5927\u4e8e\u51ed\u8bc1\u7ed3\u675f\u65e5,\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\uff0c\u8c22\u8c22\uff01");
        }
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(supCompanySapCode);
        List billSwitches = this.billInvorker.getBillSwitchService().queryAllObjByExample((IExample)billSwitchExample);
        if (CollectionUtils.isEmpty((Collection)billSwitches)) {
            return;
        }
        for (BillSwitch billSwitch : billSwitches) {
            boolean b1;
            if (billSwitch == null || billSwitch.getSwitchFlag().equals(Constant.NO_INT)) continue;
            Date voucherStartTime = billSwitch.getVoucherStartTime();
            Date voucherEndTime = billSwitch.getVoucherEndTime();
            if (voucherStartTime == null && voucherEndTime == null || voucherStartTime != null && voucherEndTime == null || voucherStartTime == null || voucherEndTime == null) continue;
            String str = DateFormatUtils.format((Date)voucherStartTime, (String)"yyyy-MM-dd");
            String str2 = DateFormatUtils.format((Date)voucherEndTime, (String)"yyyy-MM-dd");
            this.logger.info("\u7528\u6237\u4f20\u7684\u51ed\u8bc1\u5f00\u59cb\u65e5:{}", (Object)DateFormatUtils.format((Date)postingStartTime, (String)"yyyy-MM-dd"));
            this.logger.info("\u7528\u6237\u4f20\u7684\u51ed\u8bc1\u7ed3\u675f\u65e5:{}", (Object)DateFormatUtils.format((Date)postingEndTime, (String)"yyyy-MM-dd"));
            this.logger.info("\u91c7\u8d2d\u8bbe\u7f6e\u7684\u51ed\u8bc1\u5f00\u59cb\u65e5\uff1a{}", (Object)str);
            this.logger.info("\u91c7\u8d2d\u8bbe\u7f6e\u7684\u51ed\u8bc1\u7ed3\u675f\u65e5\uff1a{}", (Object)str2);
            Date postingStartTime1 = DateUtils.truncate((Date)postingStartTime, (int)5);
            Date postingEndTime1 = DateUtils.truncate((Date)postingEndTime, (int)5);
            Date voucherStartTime1 = DateUtils.truncate((Date)voucherStartTime, (int)5);
            Date voucherEndTime1 = DateUtils.truncate((Date)voucherEndTime, (int)5);
            boolean b = postingStartTime1.getTime() >= voucherStartTime1.getTime();
            boolean bl = b1 = postingEndTime1.getTime() <= voucherEndTime1.getTime();
            if (b && b1) continue;
            throw new CommonException("\u4f60\u6240\u9009\u7684\u5bf9\u8d26\u51ed\u8bc1\u65f6\u95f4\u4e0d\u5728\u65f6\u95f4\u89c4\u5b9a\u8303\u56f4\u5185,\u5141\u8bb8\u65f6\u95f4\u4e3a\uff1a" + str + "\u5230" + str2);
        }
    }
}

