/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.utils.BillSendStatus;
import com.els.base.bill.utils.CreateBillType;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurSendCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Bill> billList;

    public PurSendCommand() {
    }

    public PurSendCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validate(this.billList);
        this.processor(this.billList);
        this.sendMessage(this.billList);
        return null;
    }

    private void sendMessage(List<Bill> billList) {
        this.logger.info("\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        billList = this.getBillInvorker().getBillService().queryAllObjByExample((IExample)billExample);
        for (Bill bill : billList) {
            HashMap<String, String> msg = new HashMap<String, String>();
            msg.put("billNo", bill.getBillNo());
            List userIdList = this.getBillInvorker().getCompanyUserRefService().queryUserOfCompany(bill.getSupCompanyId());
            if (!CollectionUtils.isNotEmpty((Collection)userIdList) || !StringUtils.isNotBlank((String)((String)userIdList.get(0)))) continue;
            Message message = Message.init(msg).setCompanyCode(bill.getPurCompanySrmCode()).setSenderId(this.getPurUser().getId()).setBusinessTypeCode("BILL_PUR_SEND").addReceiverId((String)userIdList.get(0)).setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
            this.logger.info("\u53d1\u9001\u5185\u5bb9\uff0c" + message);
        }
        this.logger.info("\u7ed3\u675f\u53d1\u9001\u6d88\u606f");
    }

    private void processor(List<Bill> billList) {
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        Bill bill = new Bill();
        bill.setPurSendStatus(BillSendStatus.YES_INT);
        this.billInvorker.getBillService().updateByExampleSelective(bill, billExample);
    }

    private void validate(List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u8bf7\u52fe\u9009\u9700\u8981\u53d1\u9001\u7684\u5355\u636e\uff01");
        ArrayList<String> ids = new ArrayList<String>();
        for (Bill bill : billList) {
            Assert.isNotNull((Object)bill.getId(), (String)"\u53d1\u9001\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            ids.add(bill.getId());
        }
        BillExample one = new BillExample();
        one.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT).andCreateBillTypeEqualTo(CreateBillType.SUP.getType());
        int count = this.billInvorker.getBillService().countByExample(one);
        if (count > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u542b\u6709\u4f9b\u5e94\u5546\u521b\u5efa\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d1\u9001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
        BillExample two = new BillExample();
        two.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT).andPurSendStatusEqualTo(Constant.NO_INT);
        int count2 = this.billInvorker.getBillService().countByExample(two);
        if (count2 != billList.size()) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u542b\u6709\u5df2\u53d1\u9001\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d1\u9001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
    }
}

