/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.utils.BillStatusConfirmEnum;
import com.els.base.bill.utils.CreateBillType;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupConfirmCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Bill> billList;

    public SupConfirmCommand() {
    }

    public SupConfirmCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validate(this.billList);
        this.processor(this.billList);
        this.sendMessage(this.billList);
        return null;
    }

    private void sendMessage(List<Bill> billList) {
        this.logger.info("\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        billList = this.getBillInvorker().getBillService().queryAllObjByExample((IExample)billExample);
        for (Bill bill : billList) {
            User user = this.getBillInvorker().getCompanyUserRefService().queryMainUserOfCompany(bill.getPurCompanyId());
            if (user == null) continue;
            Message message = Message.init((Object)bill).setBusinessTypeCode("BILL_SUP_CONFIRM").setCompanyCode(this.getSupCompany().getCompanyCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(this.getSupUser().getId()).addReceiverId(user.getId());
            MessageSendUtils.sendMessage((Message)message);
            this.logger.info("\u53d1\u9001\u5185\u5bb9\uff0c" + message);
        }
        this.logger.info("\u7ed3\u675f\u53d1\u9001\u6d88\u606f");
    }

    private void processor(List<Bill> billList) {
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        Bill bill = new Bill();
        bill.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_CONFIRM.getConfirmStatus());
        this.billInvorker.getBillService().updateByExampleSelective(bill, billExample);
    }

    private void validate(List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u8bf7\u52fe\u9009\u9700\u8981\u786e\u8ba4\u7684\u5355\u636e\uff01");
        ArrayList<String> ids = new ArrayList<String>();
        for (Bill bill : billList) {
            Assert.isNotNull((Object)bill.getId(), (String)"\u786e\u8ba4\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            ids.add(bill.getId());
        }
        BillExample one = new BillExample();
        one.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT).andCreateBillTypeEqualTo(CreateBillType.SUP.getType());
        int count = this.billInvorker.getBillService().countByExample(one);
        if (count > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u542b\u6709\u81ea\u5df1\u521b\u5efa\u7684\u5355\u636e\uff0c\u65e0\u9700\u518d\u786e\u8ba4\u5355\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT).andSupConfirmStatusEqualTo(BillStatusConfirmEnum.STATUS_UNCONFIRM.getConfirmStatus());
        int count2 = this.billInvorker.getBillService().countByExample(billExample);
        if (billList.size() != count2) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u542b\u6709\u5df2\u786e\u8ba4\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u786e\u8ba4\u5355\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
    }
}

