/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.utils.ApproveStatusEnum;
import com.els.base.bill.utils.BillSendStatus;
import com.els.base.bill.utils.BillStatusConfirmEnum;
import com.els.base.bill.utils.BillUtil;
import com.els.base.bill.utils.CalculateBillUtil;
import com.els.base.bill.utils.CreateBillType;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.entity.BillVoucher;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupCreateCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    List<BillVoucher> billVoucherList;

    public SupCreateCommand(List<BillVoucher> billVoucherList) {
        this.billVoucherList = billVoucherList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(this.billVoucherList);
        this.process(this.billVoucherList);
        this.getBillInvorker().getBillVoucherService().switchBillVoucherFlag(this.billVoucherList, Constant.YES_INT);
        return null;
    }

    private void process(List<BillVoucher> billVoucherList) {
        Bill bill = new Bill();
        this.init(bill);
        this.setBillItem(bill, billVoucherList);
    }

    private void setBillItem(Bill bill, List<BillVoucher> billVoucherList) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u5bf9\u8d26\u5355\u884c\u4fe1\u606f");
        List<List<BillItem>> group = BillUtil.setBillItems(bill, billVoucherList);
        for (List<BillItem> list : group) {
            this.billInvorker.getBillItemService().insertBatch(list);
        }
    }

    private void init(Bill bill) {
        this.logger.info("\u5f00\u59cb\u521d\u59cb\u5316");
        bill.setId(null);
        bill.setIsEnable(Constant.YES_INT);
        bill.setProjectId(this.getProject().getId());
        String nextCode = this.billInvorker.getGenerateCodeService().getNextCode("BILL_NO");
        bill.setBillNo(nextCode);
        bill.setInvoiceSignFlag(Constant.NO_INT);
        bill.setIsEnable(Constant.YES_INT);
        bill.setSendSapFlag(Constant.NO_INT);
        bill.setSupSendStatus(Constant.NO_INT);
        bill.setPurConfirmStatus(BillStatusConfirmEnum.STATUS_UNCONFIRM.getConfirmStatus());
        bill.setPurConfirmBillStatus(Constant.NO_INT);
        bill.setPurSendStatus(BillSendStatus.NO);
        bill.setSupConfirmStatus(BillStatusConfirmEnum.NO.getConfirmStatus());
        bill.setSupConfirmBillStatus(BillSendStatus.NO_INT);
        bill.setApproveStatus(ApproveStatusEnum.NOT_AUDITED.getCode());
        bill.setCreateBillType(CreateBillType.SUP.getType());
        BillUtil.setPurCompanyInfo(this.getProject(), bill, this.billInvorker.getCompanyService());
        BillVoucher billVoucher = this.billVoucherList.get(0);
        BillUtil.setSupCompanyInfo(billVoucher.getSupCompanySapCode(), bill, this.billInvorker.getCompanyService());
        CalculateBillUtil.calculateAmount(bill, this.billVoucherList);
        bill.setCreateTime(new Date());
        bill.setSupUserName(this.getSupUser().getNickName());
        bill.setSupUserId(this.getSupUser().getId());
        this.billInvorker.getBillService().addObj(bill);
    }

    private void check(List<BillVoucher> billVoucherList) {
        this.logger.info("\u5f00\u59cb\u68c0\u67e5");
        Assert.isNotEmpty(billVoucherList, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u7269\u6599\u51ed\u8bc1\uff01");
        String companySapCode = this.getSupCompany().getCompanySapCode();
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andSwitchFlagEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(companySapCode);
        List billSwitches = this.billInvorker.getBillSwitchService().queryAllObjByExample((IExample)billSwitchExample);
        for (BillVoucher billVoucher : billVoucherList) {
            BillUtil.checkBillTime(billSwitches, billVoucher.getPostingTime());
        }
    }
}

