/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.utils.BillStatusConfirmEnum;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupRejectCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Bill> billList;

    public SupRejectCommand() {
    }

    public SupRejectCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validate(this.billList);
        this.processor(this.billList);
        this.sendMessage(this.billList);
        return null;
    }

    private void sendMessage(List<Bill> billList) {
        this.logger.info("\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        List ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        billList = this.getBillInvorker().getBillService().queryAllObjByExample((IExample)billExample);
        for (Bill bill : billList) {
            User user = this.getBillInvorker().getCompanyUserRefService().queryMainUserOfCompany(bill.getPurCompanyId());
            if (user == null) continue;
            Message message = Message.init((Object)bill).setBusinessTypeCode("BILL_SUP_REJECT").setCompanyCode(this.getSupCompany().getCompanyCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(this.getSupUser().getId()).addReceiverId(user.getId());
            MessageSendUtils.sendMessage((Message)message);
            this.logger.info("\u53d1\u9001\u5185\u5bb9\uff0c" + message);
        }
        this.logger.info("\u7ed3\u675f\u53d1\u9001\u6d88\u606f");
    }

    private void processor(List<Bill> billList) {
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn((List)ids);
        Bill bill = new Bill();
        bill.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_REJECT.getConfirmStatus());
        bill.setUpdateTime(new Date());
        this.billInvorker.getBillService().updateByExampleSelective(bill, billExample);
        this.billInvorker.getBillService().updateVoucherByBillIds(ids, Constant.NO_INT);
        this.billInvorker.getBillInvoiceService().updateBillInvoiceFlag(ids, Constant.NO_INT);
    }

    private void validate(List<Bill> billList) {
        Assert.isNotEmpty(billList, (String)"\u5f00\u7968\u6e05\u5355ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (Bill bill : billList) {
            Assert.isNotNull((Object)bill.getId(), (String)"\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

