/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.controller;

import com.els.base.bill.command.ExportReportCommand;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.entity.BillItemReport;
import com.els.base.bill.entity.BillItemReportExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.common.BillInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u884c\u5165\u9000\u5e93\u51ed\u8bc1,\u6298\u8ba9\u5355")
@Controller
@RequestMapping(value={"billItem"})
public class BillItemController {
    @Resource
    protected BillItemService billItemService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u5f00\u7968\u6e05\u5355ID\uff0c\u67e5\u8be2\u5bf9\u5e94\u7684\u6240\u6709\u7684\u6298\u8ba9\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/rebate/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillItem>> findForRebateByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillItemExample example = new BillItemExample();
        example.setPageView((PageView<BillItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillTypeIsNotNull().andIsRebateEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u5f00\u7968\u6e05\u5355ID\uff0c\u67e5\u8be2\u5bf9\u5e94\u7684\u6240\u6709\u7684sap\u5bf9\u8d26\u660e\u7ec6\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/voucher/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillItem>> findForVoucherByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillItemExample example = new BillItemExample();
        example.setPageView((PageView<BillItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillTypeIsNotNull();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5f00\u53d1\u7968\u7684\u67e5\u8be2\u63a5\u53e3\uff0c\u6839\u636e\u53d6\u6d88\u7684sap\u5bf9\u8d26\u51ed\u8bc1\uff0c\u67e5\u8be2\u5176\u5269\u4e0b\u6240\u6709\u672a\u5f00\u53d1\u7968\u7684\u7684\u6298\u8ba9\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="billId", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="billInvoiceFlag", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/rebate/reverse/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillItem>> findReverseRebateByPage(@RequestParam(required=true) String billId, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String billInvoiceFlag, @RequestBody(required=false) List<BillItem> billItemList) {
        Assert.isNotBlank((String)billId, (String)"\u5bf9\u8d26ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (CollectionUtils.isNotEmpty(billItemList)) {
            List ids = billItemList.stream().map(BillItem::getId).collect(Collectors.toList());
            BillItemExample example = new BillItemExample();
            example.setPageView((PageView<BillItem>)new PageView(pageNo, pageSize));
            example.setOrderByClause("CREATE_TIME DESC");
            BillItemExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT).andBillIdEqualTo(billId).andIsRebateEqualTo(Constant.YES_INT).andBillTypeIsNotNull().andIdNotIn(ids);
            if (StringUtils.isNotBlank((String)billInvoiceFlag)) {
                if (!StringUtils.isNumeric((String)billInvoiceFlag)) {
                    throw new CommonException("\u4f20\u8f93\u53c2\u6570billInvoiceFlag=" + billInvoiceFlag + "\u6709\u8bef\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u4f20\uff01");
                }
                criteria.andBillInvoiceFlagEqualTo(Integer.valueOf(billInvoiceFlag));
            }
            PageView pageData = this.billItemService.queryObjByPage((IExample)example);
            return ResponseResult.success((Object)pageData);
        }
        BillItemExample example = new BillItemExample();
        example.setPageView((PageView<BillItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillIdEqualTo(billId).andBillTypeIsNotNull().andIsRebateEqualTo(Constant.YES_INT);
        if (StringUtils.isNotBlank((String)billInvoiceFlag)) {
            if (!StringUtils.isNumeric((String)billInvoiceFlag)) {
                throw new CommonException("\u4f20\u8f93\u53c2\u6570billInvoiceFlag=" + billInvoiceFlag + "\u6709\u8bef\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u4f20\uff01");
            }
            criteria.andBillInvoiceFlagEqualTo(Integer.valueOf(billInvoiceFlag));
        }
        PageView pageData = this.billItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5f00\u53d1\u7968\u7684\u67e5\u8be2\u63a5\u53e3\uff0c\u6839\u636e\u9009\u62e9\u7684sap\u5bf9\u8d26\u51ed\u8bc1\uff0c\u67e5\u8be2\u5176\u5bf9\u5e94\u7684\u672a\u5f00\u53d1\u7968\u7684\u7684\u6298\u8ba9\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="billId", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="billInvoiceFlag", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/rebate/positive/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillItem>> findPositiveRebateByPage(@RequestParam(required=true) String billId, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String billInvoiceFlag, @RequestBody(required=false) List<BillItem> billItemList) {
        Assert.isNotBlank((String)billId, (String)"\u5bf9\u8d26ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (CollectionUtils.isNotEmpty(billItemList)) {
            List ids = billItemList.stream().map(BillItem::getId).collect(Collectors.toList());
            BillItemExample example = new BillItemExample();
            example.setPageView((PageView<BillItem>)new PageView(pageNo, pageSize));
            example.setOrderByClause("CREATE_TIME DESC");
            BillItemExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT).andBillIdEqualTo(billId).andIdIn(ids).andBillTypeIsNotNull().andIsRebateEqualTo(Constant.YES_INT);
            if (StringUtils.isNotBlank((String)billInvoiceFlag)) {
                if (!StringUtils.isNumeric((String)billInvoiceFlag)) {
                    throw new CommonException("\u4f20\u8f93\u53c2\u6570billInvoiceFlag=" + billInvoiceFlag + "\u6709\u8bef\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u4f20\uff01");
                }
                criteria.andBillInvoiceFlagEqualTo(Integer.valueOf(billInvoiceFlag));
            }
            PageView pageData = this.billItemService.queryObjByPage((IExample)example);
            return ResponseResult.success((Object)pageData);
        }
        PageView pageData = new PageView();
        pageData.setQueryResult(new ArrayList());
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7ed3\u7b97\u6838\u7968\u6e05\u5355\u62a5\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findBillItemReportByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillItemReport>> findBillItemReportByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillItemReportExample example = new BillItemReportExample();
        example.setPageView((PageView<BillItemReport>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BillItemReportExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillTypeIsNotNull();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<BillItemReport> pageData = this.billItemService.queryBillItemReportByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa\u5bf9\u8d26\u6e05\u5355\u6570\u636e", httpMethod="POST")
    @RequestMapping(value={"service/exportBillItemReport", "service/pur/exportBillItemReport"})
    @ResponseBody
    public ResponseResult<FileData> exportBillItemReport(@RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        ExportReportCommand cmd = new ExportReportCommand(wapper);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }
}

