/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.service.impl;

import com.els.base.bill.dao.BillItemMapper;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.entity.BillItemReport;
import com.els.base.bill.entity.BillItemReportExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillItemService")
public class BillItemServiceImpl
implements BillItemService {
    @Resource
    protected BillItemMapper billItemMapper;

    @Override
    @Transactional
    @CacheEvict(value={"billItem"}, allEntries=true)
    public int updateByExampleSelective(BillItem record, BillItemExample example) {
        return this.billItemMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"billItem"}, allEntries=true)
    public int insertBatch(List<BillItem> list) {
        Assert.isNotEmpty(list, (String)"\u5f00\u7968\u6e05\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.billItemMapper.insertBatch(list);
    }

    @Override
    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public int countByExample(BillItemExample example) {
        return this.billItemMapper.countByExample(example);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    public void addObj(BillItem t) {
        this.billItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    public void modifyObj(BillItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public BillItem queryObjById(String id) {
        return this.billItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public List<BillItem> queryAllObjByExample(BillItemExample example) {
        return this.billItemMapper.selectByExample(example);
    }

    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public PageView<BillItem> queryObjByPage(BillItemExample example) {
        PageView<BillItem> pageView = example.getPageView();
        pageView.setQueryResult(this.billItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public PageView<BillItemReport> queryBillItemReportByPage(BillItemReportExample example) {
        PageView<BillItemReport> pageView = example.getPageView();
        pageView.setQueryResult(this.billItemMapper.selectBillItemReportByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"billItem"}, keyGenerator="redisKeyGenerator")
    public List<BillItemReport> queryBillItemReportForExcel(BillItemReportExample example) {
        return this.billItemMapper.selectBillItemReportForExcel(example);
    }
}

