/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.utils;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillItem;
import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.voucher.entity.BillVoucher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BillUtil {
    private static Logger logger = LoggerFactory.getLogger(BillUtil.class);

    public static Bill setPurCompanyInfo(Project project, Bill bill, CompanyService companyService) {
        Company purCompany = (Company)companyService.queryObjById((Object)project.getCompanyId());
        Assert.isNotNull((Object)purCompany, (String)"\u91c7\u8d2d\u57fa\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        bill.setPurCompanyId(purCompany.getId());
        bill.setPurCompanySrmCode(purCompany.getCompanyCode());
        bill.setPurCompanySapCode(purCompany.getCompanySapCode());
        bill.setPurCompanyName(purCompany.getCompanyName());
        bill.setPurCompanyFullName(purCompany.getCompanyFullName());
        return bill;
    }

    public static Bill setSupCompanyInfo(String supCompanySapCode, Bill bill, CompanyService companyService) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanySapCodeEqualTo(supCompanySapCode);
        List companies = companyService.queryAllObjByExample((IExample)companyExample);
        Assert.isNotEmpty((Collection)companies, (String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u4e3b\u6570\u636e\u7ef4\u62a4\uff0c\u8c22\u8c22\uff01");
        Company supCompany = (Company)companies.get(0);
        Assert.isNotNull((Object)supCompany, (String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        bill.setSupCompanyId(supCompany.getId());
        bill.setSupCompanySrmCode(supCompany.getCompanyCode());
        bill.setSupCompanySapCode(supCompanySapCode);
        bill.setSupCompanyName(supCompany.getCompanyName());
        bill.setSupCompanyFullName(supCompany.getCompanyFullName());
        bill.setSupComtactTelephone(supCompany.getTelephone());
        bill.setSupComtactUserName(supCompany.getContacts());
        bill.setSupCompanyAddress(supCompany.getAddress());
        bill.setPayConditionsCode(supCompany.getPayConditionsCode());
        bill.setPayConditionsDesc(supCompany.getPayConditionsDesc());
        bill.setTaxRate(supCompany.getTaxRate());
        bill.setTaxCode(supCompany.getTaxCode());
        bill.setCurrencyType(supCompany.getOrderCurren());
        return bill;
    }

    public static List<List<BillItem>> setBillItems(Bill bill, List<BillVoucher> billVoucherList) {
        ArrayList<BillItem> billItems = new ArrayList<BillItem>();
        for (BillVoucher billVoucher : billVoucherList) {
            BillItem billItem = new BillItem();
            BeanUtils.copyProperties((Object)billVoucher, (Object)billItem);
            billItem.setId(UUIDGenerator.generateUUID());
            billItem.setBillId(bill.getId());
            billItem.setBillNo(bill.getBillNo());
            billItem.setIsEnable(Constant.YES_INT);
            billItem.setVoucherId(billVoucher.getId());
            billItem.setBillFlag(Constant.YES_INT);
            billItem.setBillInvoiceFlag(Constant.NO_INT);
            billItems.add(billItem);
        }
        List group = Lists.partition(billItems, (int)10);
        return group;
    }

    public static void checkBillTime(List<BillSwitch> billSwitches, Date postingTime) {
        if (CollectionUtils.isNotEmpty(billSwitches)) {
            for (BillSwitch billSwitch : billSwitches) {
                boolean b1;
                Integer startTime = billSwitch.getStartTime();
                Integer endTime = billSwitch.getEndTime();
                logger.info("\u91c7\u8d2d\u5458\u8bbe\u7f6e\u7684\u5f00\u7968\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a{}", (Object)startTime);
                logger.info("\u91c7\u8d2d\u5458\u8bbe\u7f6e\u7684\u5f00\u7968\u7ed3\u675f\u65f6\u95f4\u4e3a\uff1a{}", (Object)endTime);
                Calendar calendar = Calendar.getInstance();
                int date = calendar.get(5);
                logger.info("\u7cfb\u7edf\u5f53\u524d\u5929\u6570\u4e3a\uff1a{}", (Object)date);
                if (startTime != null & startTime != null && (date < startTime || date > endTime)) {
                    throw new CommonException("\u4e0d\u5728\u5bf9\u8d26\u65f6\u95f4\u5185,\u8bf7\u8054\u7cfb\u91c7\u8d2d\u5458\u8bbe\u7f6e\u5bf9\u8d26\u65f6\u95f4\uff0c\u8c22\u8c22\uff01");
                }
                Date voucherStartTime = billSwitch.getVoucherStartTime();
                Date voucherEndTime = billSwitch.getVoucherEndTime();
                if (voucherStartTime == null || voucherEndTime == null) continue;
                String str = DateFormatUtils.format((Date)voucherStartTime, (String)"yyyy-MM-dd");
                String str2 = DateFormatUtils.format((Date)voucherEndTime, (String)"yyyy-MM-dd");
                logger.info("\u91c7\u8d2d\u8bbe\u7f6e\u7684\u51ed\u8bc1\u5f00\u59cb\u65e5\uff1a{}", (Object)str);
                logger.info("\u91c7\u8d2d\u8bbe\u7f6e\u7684\u51ed\u8bc1\u7ed3\u675f\u65e5\uff1a{}", (Object)str2);
                Date voucherStartTime1 = DateUtils.truncate((Date)voucherStartTime, (int)5);
                Date voucherEndTime1 = DateUtils.truncate((Date)voucherEndTime, (int)5);
                Assert.isNotNull((Object)postingTime, (String)"\u51ed\u8bc1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                Date postingTime1 = DateUtils.truncate((Date)postingTime, (int)5);
                boolean b = postingTime1.getTime() >= voucherStartTime1.getTime();
                boolean bl = b1 = postingTime1.getTime() <= voucherEndTime1.getTime();
                if (b && b1) continue;
                throw new CommonException("\u4f60\u6240\u9009\u7684\u5bf9\u8d26\u51ed\u8bc1\u65f6\u95f4\u4e0d\u5728\u65f6\u95f4\u89c4\u5b9a\u8303\u56f4\u5185,\u5141\u8bb8\u65f6\u95f4\u4e3a\uff1a" + str + "\u5230" + str2);
            }
        }
    }
}

