/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.category.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;
import java.util.Date;

public class EditCommand
extends AbstractBillCommand<String> {
    private CompanyCategory companyCategory;

    public EditCommand(CompanyCategory companyCategory) {
        this.companyCategory = companyCategory;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(this.companyCategory);
        this.process(this.companyCategory);
        return null;
    }

    private void process(CompanyCategory companyCategory) {
        CompanyCategory category = (CompanyCategory)this.billInvorker.getCompanyCategoryService().queryObjById(companyCategory.getId());
        Assert.isNotNull((Object)category, (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\uff01");
        category.setRemark(companyCategory.getRemark());
        category.setCategoryName(companyCategory.getCategoryName());
        category.setUpdateTime(new Date());
        this.billInvorker.getCompanyCategoryService().modifyObj(category);
        this.updateCompanyCategoryRef(category);
        this.updateCategoryBillSwitch(category);
        this.updateBillSwitch(category);
    }

    private void updateBillSwitch(CompanyCategory category) {
        BillSwitchExample example = new BillSwitchExample();
        example.createCriteria().andCategoryNoEqualTo(category.getCategoryNo());
        int i = this.billInvorker.getBillSwitchService().countByExample(example);
        if (i > 0) {
            BillSwitch billSwitch = new BillSwitch();
            billSwitch.setCategoryName(category.getCategoryName());
            billSwitch.setCategoryNo(category.getCategoryNo());
            this.billInvorker.getBillSwitchService().updateByExampleSelective(billSwitch, example);
        }
    }

    private void updateCategoryBillSwitch(CompanyCategory category) {
        CategoryBillSwitchExample example = new CategoryBillSwitchExample();
        example.createCriteria().andCategoryNoEqualTo(category.getCategoryNo());
        int i = this.billInvorker.getCategoryBillSwitchService().countByExample(example);
        if (i > 0) {
            CategoryBillSwitch categoryBillSwitch = new CategoryBillSwitch();
            categoryBillSwitch.setCategoryName(category.getCategoryName());
            categoryBillSwitch.setCategoryNo(category.getCategoryNo());
            this.billInvorker.getCategoryBillSwitchService().updateByExampleSelective(categoryBillSwitch, example);
        }
    }

    private void updateCompanyCategoryRef(CompanyCategory category) {
        CompanyCategoryRefExample example = new CompanyCategoryRefExample();
        example.createCriteria().andCategoryNoEqualTo(category.getCategoryNo());
        int i = this.billInvorker.getCompanyCategoryRefService().countByExample(example);
        if (i > 0) {
            CompanyCategoryRef companyCategoryRef = new CompanyCategoryRef();
            companyCategoryRef.setCategoryName(category.getCategoryName());
            companyCategoryRef.setCategoryNo(category.getCategoryNo());
            this.billInvorker.getCompanyCategoryRefService().updateByExampleSelective(companyCategoryRef, example);
        }
    }

    private void check(CompanyCategory companyCategory) {
        Assert.isNotBlank((String)companyCategory.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        Assert.isNotBlank((String)companyCategory.getCategoryName(), (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
    }
}

