/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.category.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.category.command.CreateCommand;
import com.els.base.category.command.DeleteCommand;
import com.els.base.category.command.EditCommand;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.category.entity.CompanyCategoryExample;
import com.els.base.category.service.CompanyCategoryService;
import com.els.base.common.BillInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u5206\u7ec4\uff0c\u5206\u7c7b\u4fe1\u606f")
@Controller
@RequestMapping(value={"companyCategory"})
public class CompanyCategoryController {
    @Resource
    protected CompanyCategoryService companyCategoryService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u5206\u7ec4\uff0c\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyCategory companyCategory) {
        CreateCommand cmd = new CreateCommand(companyCategory);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u5206\u7ec4\uff0c\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyCategory companyCategory) {
        EditCommand cmd = new EditCommand(companyCategory);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u5206\u7ec4\uff0c\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        List<String> ids = Arrays.asList(id);
        DeleteCommand cmd = new DeleteCommand(ids);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u5206\u7ec4\uff0c\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        DeleteCommand cmd = new DeleteCommand(ids);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u4f9b\u5e94\u5546\u5206\u7ec4\uff0c\u5206\u7c7b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyCategory", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyCategory>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyCategoryExample example = new CompanyCategoryExample();
        example.setPageView((PageView<CompanyCategory>)new PageView(pageNo, pageSize));
        CompanyCategoryExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyCategoryService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

