/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.category.service.impl;

import com.els.base.category.dao.CompanyCategoryMapper;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.category.entity.CompanyCategoryExample;
import com.els.base.category.service.CompanyCategoryService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyCategoryService")
public class CompanyCategoryServiceImpl
implements CompanyCategoryService {
    @Resource
    protected CompanyCategoryMapper companyCategoryMapper;

    @Override
    @Cacheable(value={"companyCategory"}, keyGenerator="redisKeyGenerator")
    public int countByExample(CompanyCategoryExample example) {
        return this.companyCategoryMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"companyCategory"}, allEntries=true)
    @Transactional
    public void deleteByExample(CompanyCategoryExample example) {
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u4e0d\u80fd\u8fdb\u884c\u5168\u8868\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.companyCategoryMapper.deleteByExample(example);
    }

    @Override
    @Cacheable(value={"companyCategory"}, keyGenerator="redisKeyGenerator")
    public CompanyCategory queryCompanyCategoryByCategory(String categoryNo) {
        CompanyCategoryExample companyCategoryExample = new CompanyCategoryExample();
        companyCategoryExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCategoryNoEqualTo(categoryNo);
        List<CompanyCategory> companyCategories = this.companyCategoryMapper.selectByExample(companyCategoryExample);
        if (CollectionUtils.isNotEmpty(companyCategories)) {
            return companyCategories.get(0);
        }
        return null;
    }

    @CacheEvict(value={"companyCategory"}, allEntries=true)
    public void addObj(CompanyCategory t) {
        this.companyCategoryMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyCategory"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyCategoryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyCategory"}, allEntries=true)
    public void modifyObj(CompanyCategory t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyCategoryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyCategory"}, keyGenerator="redisKeyGenerator")
    public CompanyCategory queryObjById(String id) {
        return this.companyCategoryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyCategory"}, keyGenerator="redisKeyGenerator")
    public List<CompanyCategory> queryAllObjByExample(CompanyCategoryExample example) {
        return this.companyCategoryMapper.selectByExample(example);
    }

    @Cacheable(value={"companyCategory"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyCategory> queryObjByPage(CompanyCategoryExample example) {
        PageView<CompanyCategory> pageView = example.getPageView();
        pageView.setQueryResult(this.companyCategoryMapper.selectByExampleByPage(example));
        return pageView;
    }
}

