/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.categoryref.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.category.entity.CompanyCategoryExample;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class AppointCommand
extends AbstractBillCommand<String> {
    String companyCategoryNo;
    List<Company> companyList;

    public AppointCommand(String companyCategoryNo, List<Company> companyList) {
        this.companyCategoryNo = companyCategoryNo;
        this.companyList = companyList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(this.companyCategoryNo, this.companyList);
        this.process(this.companyCategoryNo, this.companyList);
        return null;
    }

    private void check(String companyCategoryNo, List<Company> companyList) {
        Assert.isNotBlank((String)companyCategoryNo, (String)"\u5206\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CompanyCategoryExample companyCategoryExample = new CompanyCategoryExample();
        companyCategoryExample.createCriteria().andCategoryNoEqualTo(companyCategoryNo).andIsEnableEqualTo(Constant.YES_INT);
        int i = this.billInvorker.getCompanyCategoryService().countByExample(companyCategoryExample);
        if (i == 0) {
            throw new CommonException("\u5206\u7ec4\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Assert.isNotEmpty(companyList, (String)"\u5206\u914d\u7684\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (Company company : companyList) {
            Assert.isNotBlank((String)company.getCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void process(String companyCategoryNo, List<Company> companyList) {
        List companySapCode = companyList.stream().map(Company::getCompanySapCode).collect(Collectors.toList());
        CompanyExample example = new CompanyExample();
        example.createCriteria().andCompanySapCodeIn(companySapCode);
        companyList = this.billInvorker.getCompanyService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)companyList, (String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.updateCompanyCategoryRef(companyCategoryNo, companyList);
        this.updateCategoryBillSwitch(companyCategoryNo, companyList);
    }

    private void updateCategoryBillSwitch(String companyCategoryNo, List<Company> companyList) {
        CategoryBillSwitchExample categoryBillSwitchExample = new CategoryBillSwitchExample();
        categoryBillSwitchExample.createCriteria().andCategoryNoEqualTo(companyCategoryNo).andIsEnableEqualTo(Constant.YES_INT);
        List categoryBillSwitches = this.billInvorker.getCategoryBillSwitchService().queryAllObjByExample((IExample)categoryBillSwitchExample);
        if (CollectionUtils.isEmpty((Collection)categoryBillSwitches)) {
            return;
        }
        this.updateBillSwitch(categoryBillSwitches, companyList);
    }

    private void updateBillSwitch(List<CategoryBillSwitch> categoryBillSwitches, List<Company> companyList) {
        CategoryBillSwitch categoryBillSwitch = categoryBillSwitches.get(0);
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andCategoryNoEqualTo(categoryBillSwitch.getCategoryNo());
        this.billInvorker.getBillSwitchService().deleteByExample(billSwitchExample);
        ArrayList<BillSwitch> billSwitches = new ArrayList<BillSwitch>();
        for (Company company : companyList) {
            BillSwitch billSwitch = new BillSwitch();
            billSwitch.setId(UUIDGenerator.generateUUID());
            billSwitch.setIsEnable(Constant.YES_INT);
            billSwitch.setCreateTime(new Date());
            billSwitch.setUpdateTime(new Date());
            billSwitch.setSwitchFlag(categoryBillSwitch.getSwitchFlag());
            billSwitch.setProjectId(categoryBillSwitch.getProjectId());
            billSwitch.setPurCompanyFullName(categoryBillSwitch.getPurCompanyFullName());
            billSwitch.setPurCompanyId(categoryBillSwitch.getPurCompanyId());
            billSwitch.setPurCompanyName(categoryBillSwitch.getPurCompanyName());
            billSwitch.setPurCompanySapCode(categoryBillSwitch.getPurCompanySapCode());
            billSwitch.setPurCompanySrmCode(categoryBillSwitch.getPurCompanySrmCode());
            billSwitch.setPurUserId(categoryBillSwitch.getPurUserId());
            billSwitch.setPurUserName(categoryBillSwitch.getPurUserName());
            billSwitch.setSupCompanyFullName(company.getCompanyFullName());
            billSwitch.setSupCompanyId(company.getId());
            billSwitch.setSupCompanyName(company.getCompanyName());
            billSwitch.setSupCompanySapCode(company.getCompanySapCode());
            billSwitch.setSupCompanySrmCode(company.getCompanyCode());
            billSwitch.setCategoryNo(categoryBillSwitch.getCategoryNo());
            billSwitch.setCategoryName(categoryBillSwitch.getCategoryName());
            billSwitch.setStartTime(categoryBillSwitch.getStartTime());
            billSwitch.setEndTime(categoryBillSwitch.getEndTime());
            billSwitch.setVoucherStartTime(categoryBillSwitch.getVoucherStartTime());
            billSwitch.setVoucherEndTime(categoryBillSwitch.getVoucherEndTime());
            billSwitches.add(billSwitch);
        }
        this.billInvorker.getBillSwitchService().addAll(billSwitches);
    }

    private void updateCompanyCategoryRef(String companyCategoryNo, List<Company> companyList) {
        this.deleteCompanyCategoryRef(companyCategoryNo);
        this.addCompanyCategoryRef(companyCategoryNo, companyList);
    }

    private void addCompanyCategoryRef(String companyCategoryNo, List<Company> companyList) {
        ArrayList<CompanyCategoryRef> companyCategoryRefs = new ArrayList<CompanyCategoryRef>();
        for (Company supCompany : companyList) {
            CompanyCategoryRef categoryRef = new CompanyCategoryRef();
            categoryRef.setId(UUIDGenerator.generateUUID());
            categoryRef.setIsEnable(Constant.YES_INT);
            categoryRef.setProjectId(this.getProject().getId());
            categoryRef.setPurCompanyId(this.getProject().getCompanyId());
            categoryRef.setPurCompanyFullName(this.getPurCompany().getCompanyFullName());
            categoryRef.setPurCompanySapCode(this.getPurCompany().getCompanySapCode());
            categoryRef.setPurCompanyName(this.getPurCompany().getCompanyName());
            categoryRef.setPurCompanySrmCode(this.getPurCompany().getCompanyCode());
            categoryRef.setPurUserId(this.getPurUser().getId());
            categoryRef.setPurUserName(this.getPurUser().getNickName());
            categoryRef.setSupCompanyId(supCompany.getId());
            categoryRef.setSupCompanySrmCode(supCompany.getCompanyCode());
            categoryRef.setSupCompanySapCode(supCompany.getCompanySapCode());
            categoryRef.setSupCompanyName(supCompany.getCompanyName());
            categoryRef.setSupCompanyFullName(supCompany.getCompanyFullName());
            categoryRef.setCategoryNo(companyCategoryNo);
            CompanyCategory companyCategory = this.billInvorker.getCompanyCategoryService().queryCompanyCategoryByCategory(companyCategoryNo);
            if (companyCategory != null) {
                categoryRef.setCategoryName(companyCategory.getCategoryName());
            }
            companyCategoryRefs.add(categoryRef);
        }
        this.billInvorker.getCompanyCategoryRefService().addAll(companyCategoryRefs);
    }

    private void deleteCompanyCategoryRef(String companyCategoryNo) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCategoryNoEqualTo(companyCategoryNo);
        this.billInvorker.getCompanyCategoryRefService().deleteByExample(companyCategoryRefExample);
    }
}

