/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.categoryswitch.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;

public class CreateCommand
extends AbstractBillCommand<String> {
    private CategoryBillSwitch categoryBillSwitch;

    public CreateCommand(CategoryBillSwitch categoryBillSwitch) {
        this.categoryBillSwitch = categoryBillSwitch;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(this.categoryBillSwitch);
        this.process(this.categoryBillSwitch);
        return null;
    }

    private void process(CategoryBillSwitch categoryBillSwitch) {
        this.insertCategoryBillSwitch(categoryBillSwitch);
        this.insertBillSwitch(categoryBillSwitch);
    }

    private void insertBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        List<CompanyCategoryRef> companyCategoryRefList = this.billInvorker.getCompanyCategoryRefService().findByCompanyCategoryNo(categoryBillSwitch.getCategoryNo());
        Assert.isNotEmpty(companyCategoryRefList, (String)"\u5c1a\u672a\u7ed9\u8be5\u4f9b\u5e94\u5546\u5206\u7ec4\u6307\u5b9a\u4f9b\u5e94\u5546\uff0c\u8bf7\u6307\u5b9a\uff01");
        this.deleteBillSwitch(categoryBillSwitch);
        this.insertBillSwitch(categoryBillSwitch, companyCategoryRefList);
    }

    private void insertBillSwitch(CategoryBillSwitch categoryBillSwitch, List<CompanyCategoryRef> companyCategoryRefList) {
        ArrayList<BillSwitch> list = new ArrayList<BillSwitch>();
        for (CompanyCategoryRef companyCategoryRef : companyCategoryRefList) {
            BillSwitch billSwitch = new BillSwitch();
            billSwitch.setId(UUIDGenerator.generateUUID());
            billSwitch.setIsEnable(Constant.YES_INT);
            billSwitch.setProjectId(categoryBillSwitch.getProjectId());
            billSwitch.setCreateTime(new Date());
            billSwitch.setUpdateTime(new Date());
            billSwitch.setSwitchFlag(categoryBillSwitch.getSwitchFlag());
            billSwitch.setStartTime(categoryBillSwitch.getStartTime());
            billSwitch.setEndTime(categoryBillSwitch.getEndTime());
            billSwitch.setPurCompanyId(categoryBillSwitch.getPurCompanyId());
            billSwitch.setPurCompanyFullName(categoryBillSwitch.getPurCompanyFullName());
            billSwitch.setPurCompanyName(categoryBillSwitch.getPurCompanyName());
            billSwitch.setPurCompanySapCode(categoryBillSwitch.getPurCompanySapCode());
            billSwitch.setPurCompanySrmCode(categoryBillSwitch.getPurCompanySrmCode());
            billSwitch.setPurUserId(categoryBillSwitch.getPurUserId());
            billSwitch.setPurUserName(categoryBillSwitch.getPurUserName());
            billSwitch.setSupCompanyId(companyCategoryRef.getSupCompanyId());
            billSwitch.setSupCompanyFullName(companyCategoryRef.getSupCompanyFullName());
            billSwitch.setSupCompanyName(companyCategoryRef.getSupCompanyName());
            billSwitch.setSupCompanySapCode(companyCategoryRef.getSupCompanySapCode());
            billSwitch.setSupCompanySrmCode(companyCategoryRef.getSupCompanySrmCode());
            billSwitch.setCategoryNo(categoryBillSwitch.getCategoryNo());
            billSwitch.setCategoryName(categoryBillSwitch.getCategoryName());
            billSwitch.setVoucherStartTime(categoryBillSwitch.getVoucherStartTime());
            billSwitch.setVoucherEndTime(categoryBillSwitch.getVoucherEndTime());
            list.add(billSwitch);
        }
        this.billInvorker.getBillSwitchService().addAll(list);
    }

    private void deleteBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCategoryNoEqualTo(categoryBillSwitch.getCategoryNo());
        this.billInvorker.getBillSwitchService().deleteByExample(billSwitchExample);
    }

    private void insertCategoryBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        categoryBillSwitch.setId(UUIDGenerator.generateUUID());
        categoryBillSwitch.setProjectId(this.getProject().getId());
        categoryBillSwitch.setIsEnable(Constant.YES_INT);
        if (categoryBillSwitch.getSwitchFlag() == null) {
            categoryBillSwitch.setSwitchFlag(Constant.YES_INT);
        }
        categoryBillSwitch.setCreateTime(new Date());
        categoryBillSwitch.setPurCompanyId(this.getProject().getCompanyId());
        categoryBillSwitch.setPurCompanyName(this.getPurCompany().getCompanyName());
        categoryBillSwitch.setPurCompanyFullName(this.getPurCompany().getCompanyFullName());
        categoryBillSwitch.setPurCompanySapCode(this.getPurCompany().getCompanySapCode());
        categoryBillSwitch.setPurCompanySrmCode(this.getPurCompany().getCompanyCode());
        categoryBillSwitch.setPurUserId(this.getPurUser().getId());
        categoryBillSwitch.setPurUserName(this.getPurUser().getNickName());
        CompanyCategory companyCategory = this.billInvorker.getCompanyCategoryService().queryCompanyCategoryByCategory(categoryBillSwitch.getCategoryNo());
        if (companyCategory != null) {
            categoryBillSwitch.setCategoryName(companyCategory.getCategoryName());
        }
        this.initVoucher(categoryBillSwitch);
        this.billInvorker.getCategoryBillSwitchService().insert(categoryBillSwitch);
    }

    private void initVoucher(CategoryBillSwitch categoryBillSwitch) {
        if (categoryBillSwitch.getVoucherStartTime() != null) {
            Date start = DateUtils.truncate((Date)categoryBillSwitch.getVoucherStartTime(), (int)5);
            categoryBillSwitch.setVoucherStartTime(start);
        }
        if (categoryBillSwitch.getVoucherEndTime() != null) {
            Date end = DateUtils.truncate((Date)categoryBillSwitch.getVoucherEndTime(), (int)5);
            categoryBillSwitch.setVoucherEndTime(end);
        }
    }

    private void check(CategoryBillSwitch categoryBillSwitch) {
        Assert.isNotNull((Object)categoryBillSwitch, (String)"\u5bf9\u8d26\u65f6\u95f4\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a");
        String categoryNo = categoryBillSwitch.getCategoryNo();
        Assert.isNotBlank((String)categoryNo, (String)"\u4f9b\u5e94\u5546\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)categoryBillSwitch.getStartTime(), (String)"\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)categoryBillSwitch.getEndTime(), (String)"\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a");
        if (categoryBillSwitch.getStartTime() < 1 || categoryBillSwitch.getStartTime() > 31) {
            throw new CommonException("\u8bf7\u8f93\u51651-31\u7684\u6574\u6570!");
        }
        if (categoryBillSwitch.getEndTime() < 1 || categoryBillSwitch.getEndTime() > 31) {
            throw new CommonException("\u8bf7\u8f93\u51651-31\u7684\u6574\u6570!");
        }
        if (categoryBillSwitch.getVoucherStartTime() != null) {
            Assert.isNotNull((Object)categoryBillSwitch.getVoucherEndTime(), (String)"\u51ed\u8bc1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (categoryBillSwitch.getVoucherEndTime() != null) {
            Assert.isNotNull((Object)categoryBillSwitch.getVoucherStartTime(), (String)"\u51ed\u8bc1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CategoryBillSwitchExample categoryBillSwitchExample = new CategoryBillSwitchExample();
        categoryBillSwitchExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCategoryNoEqualTo(categoryNo);
        int i = this.billInvorker.getCategoryBillSwitchService().countByExample(categoryBillSwitchExample);
        if (i > 0) {
            throw new CommonException("\u8be5\u5206\u7ec4\u5df2\u7ecf\u521b\u5efa\u8fc7\u5f00\u7968\u65f6\u95f4\u4e86\uff0c\u8bf7\u68c0\u67e5\uff0c\u8c22\u8c22\uff01");
        }
    }
}

