/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.invoice.command;

import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.utils.CalculateBillUtil;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.rebate.entity.BillInvoiceRebate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class CreateCommand
extends AbstractBillCommand<BillInvoice> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int BILL_INVOICE_SIZE = 200;
    private BillInvoice billInvoice;

    public CreateCommand() {
    }

    public CreateCommand(BillInvoice billInvoice) {
        this.billInvoice = billInvoice;
    }

    @Override
    public BillInvoice execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validate(this.billInvoice);
        this.processor(this.billInvoice);
        return null;
    }

    private void processor(BillInvoice billInvoice) {
        List<BillItem> billItemList = billInvoice.getBillVoucherList();
        Assert.isNotEmpty(billItemList, (String)"\u5165\u9000\u5e93\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillItem billItem = billItemList.get(0);
        billInvoice.setInvoiceFlag(Constant.YES_INT);
        billInvoice.setTaxRate(billItem.getTaxRate());
        billInvoice.setTaxCode(billItem.getTaxCode());
        billInvoice.setCurrencyType(billItem.getCurrencyType());
        billInvoice.setCreateTime(new Date());
        billInvoice.setInvoiceSignFlag(Constant.NO_INT);
        CalculateBillUtil.calculateInvoiceAmount(billInvoice, billItemList);
        this.billInvorker.getBillInvoiceService().addObj(billInvoice);
        List ids = billItemList.stream().map(BillItem::getId).collect(Collectors.toList());
        BillItem temp = new BillItem();
        temp.setBillInvoiceId(billInvoice.getId());
        temp.setBillInvoiceFlag(Constant.YES_INT);
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andIdIn(ids);
        this.billInvorker.getBillItemService().updateByExampleSelective(temp, billItemExample);
        BillItemExample rebateExample = new BillItemExample();
        rebateExample.createCriteria().andIdIn(ids).andIsRebateEqualTo(Constant.YES_INT);
        List list = this.billInvorker.getBillItemService().queryAllObjByExample((IExample)rebateExample);
        List<BillItem> billItemsByJava8 = this.getBillItemsByJava8(list);
        if (CollectionUtils.isEmpty(billItemsByJava8)) {
            return;
        }
        this.logger.info("\u6c47\u603b\u540e\u7684\u6298\u8ba9\u5355\u884c\uff1a{}", (Object)billItemsByJava8.toString());
        ArrayList<BillInvoiceRebate> billInvoiceRebates = new ArrayList<BillInvoiceRebate>();
        for (BillItem tempBillItem : billItemsByJava8) {
            BillInvoiceRebate billInvoiceRebate = new BillInvoiceRebate();
            BeanUtils.copyProperties((Object)tempBillItem, (Object)billInvoiceRebate);
            billInvoiceRebate.setId(null);
            billInvoiceRebate.setDbCrInd("H");
            billInvoiceRebates.add(billInvoiceRebate);
        }
        this.billInvorker.getBillInvoiceRebateService().addAll(billInvoiceRebates);
    }

    private void validate(BillInvoice billInvoice) {
        Assert.isNotNull((Object)billInvoice, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billInvoice.getBillId(), (String)"\u5f00\u7968\u6e05\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getInvoiceNo(), (String)"\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)billInvoice.getInvoiceTime(), (String)"\u53d1\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<BillItem> billItemList = billInvoice.getBillVoucherList();
        Assert.isNotEmpty(billItemList, (String)"\u8bf7\u9009\u62e9\u8981\u5f00\u53d1\u7968\u7684\u6570\u636e\uff01");
        if (billItemList.size() > 200) {
            throw new CommonException("\u53d1\u7968\u884c\u6570\u4e0d\u80fd\u8d85\u8fc7200\u884c\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        int length = StringUtils.trim((String)billInvoice.getInvoiceNo()).length();
        if (length > 18) {
            throw new CommonException("\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc718\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andInvoiceFlagEqualTo(Constant.YES_INT).andInvoiceNoEqualTo(billInvoice.getInvoiceNo());
        int i = this.billInvorker.getBillInvoiceService().countByExample(billInvoiceExample);
        if (i > 0) {
            throw new CommonException("\u53d1\u7968\u53f7\u5df2\u7ecf\u5b58\u5728\u4e86\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728\u91cd\u5f00\uff01");
        }
        List ids = billItemList.stream().map(BillItem::getId).collect(Collectors.toList());
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT).andBillInvoiceFlagEqualTo(Constant.YES_INT);
        int i2 = this.billInvorker.getBillItemService().countByExample(billItemExample);
        if (i2 > 0) {
            throw new CommonException("\u5b58\u5728\u5df2\u5f00\u7968\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private List<BillItem> getBillItemsByJava8(List<BillItem> billItems) {
        ArrayList<BillItem> newBillList = new ArrayList<BillItem>();
        Map listMap = billItems.stream().collect(Collectors.groupingBy(p -> p.getMaterialNo() + p.getFactory(), Collectors.toList()));
        this.logger.info("\u6839\u636e\u7269\u6599\u53f7\u548c\u5de5\u5382\u5206\u7ec4\u4fe1\u606f\u4e3a\uff1a{}", listMap);
        for (Map.Entry entry : listMap.entrySet()) {
            List value = entry.getValue();
            BillItem billItem = (BillItem)value.get(0);
            BigDecimal materialQuantity = value.stream().map(BillItem::getMaterialQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItem.setMaterialQuantity(materialQuantity);
            BigDecimal orderAmount = value.stream().map(BillItem::getOrderAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItem.setOrderAmount(orderAmount);
            BigDecimal notIncludeTaxAmount = value.stream().map(BillItem::getNotIncludeTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItem.setNotIncludeTaxAmount(notIncludeTaxAmount);
            BigDecimal taxAmount = value.stream().map(BillItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItem.setTaxAmount(taxAmount);
            BigDecimal includeTaxAmount = value.stream().map(BillItem::getIncludeTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItem.setIncludeTaxAmount(includeTaxAmount);
            BigDecimal rebateNotIncludeTaxAmount = value.stream().map(BillItem::getRebateNotIncludeTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItem.setRebateNotIncludeTaxAmount(rebateNotIncludeTaxAmount);
            BigDecimal rebateTaxAmount = value.stream().map(BillItem::getRebateTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItem.setRebateTaxAmount(rebateTaxAmount);
            BigDecimal rebateIncludeTaxAmount = value.stream().map(BillItem::getRebateIncludeTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billItem.setRebateIncludeTaxAmount(rebateIncludeTaxAmount);
            newBillList.add(billItem);
        }
        return newBillList;
    }
}

