/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.invoice.command;

import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCommand
extends AbstractBillCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> ids;

    public DeleteCommand() {
    }

    public DeleteCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.validate(this.ids);
        this.processor(this.ids);
        return null;
    }

    private void processor(List<String> ids) {
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andIdIn((List)ids);
        List billInvoices = this.billInvorker.getBillInvoiceService().queryAllObjByExample((IExample)billInvoiceExample);
        Assert.isNotEmpty((Collection)billInvoices, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
        for (BillInvoice billInvoice : billInvoices) {
            this.updateBillItemForInvoiceDelete(billInvoice, Constant.NO_INT);
            this.billInvorker.getBillInvoiceRebateService().deleteInvoiceRebate(billInvoice);
        }
        this.billInvorker.getBillInvoiceService().deleteByExample(billInvoiceExample);
    }

    private void validate(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\uff01");
        for (String id : ids) {
            Assert.isNotBlank((String)id, (String)"\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void updateBillItemForInvoiceDelete(BillInvoice billInvoice, Integer flag) {
        Assert.isNotNull((Object)billInvoice, (String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)billInvoice.getId(), (String)"\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria().andBillInvoiceIdEqualTo(billInvoice.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List billItems = this.billInvorker.getBillItemService().queryAllObjByExample((IExample)billItemExample);
        if (CollectionUtils.isEmpty((Collection)billItems)) {
            return;
        }
        for (BillItem billItem : billItems) {
            billItem.setBillInvoiceId(billInvoice.getId());
            billItem.setBillInvoiceFlag(flag);
            this.billInvorker.getBillItemService().modifyObj(billItem);
        }
    }
}

