/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.invoice.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bill.service.BillItemService;
import com.els.base.common.BillInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.invoice.command.CreateCommand;
import com.els.base.invoice.command.DeleteCommand;
import com.els.base.invoice.command.EditCommand;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
@Controller
@RequestMapping(value={"billInvoice"})
public class BillInvoiceController {
    @Resource
    protected BillInvoiceService billInvoiceService;
    @Resource
    protected BillItemService billItemService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BillInvoice billInvoice) {
        CreateCommand cmd = new CreateCommand(billInvoice);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BillInvoice billInvoice) {
        EditCommand cmd = new EditCommand(billInvoice);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        DeleteCommand cmd = new DeleteCommand(Arrays.asList(id));
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        DeleteCommand cmd = new DeleteCommand(ids);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u9884\u5236\u53d1\u7968")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillInvoice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillInvoice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillInvoiceExample example = new BillInvoiceExample();
        example.setPageView((PageView<BillInvoice>)new PageView(pageNo, pageSize));
        BillInvoiceExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billInvoiceService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u67e5\u8be2\u5168\u90e8\u9884\u5236\u53d1\u7968")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillInvoice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<BillInvoice>> findAll(@RequestBody(required=false) QueryParamWapper wapper) {
        BillInvoiceExample example = new BillInvoiceExample();
        BillInvoiceExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List billInvoices = this.billInvoiceService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)billInvoices);
    }
}

